<?php
include 'autentica.php';
include 'conexao.php';

if ($usuario['tipo'] != 'admin') exit('Acesso negado');

$nome = $_POST['nome'] ?? '';
$email = $_POST['email'] ?? '';
$senha = $_POST['senha'] ?? '';
$tipo = $_POST['tipo'] ?? '';

if (!$nome || !$email || !$senha || !$tipo) {
    exit('Por favor, preencha todos os campos.');
}

$tipos_validos = ['admin', 'restaurante', 'motoboy'];
if (!in_array($tipo, $tipos_validos)) {
    exit('Tipo de usuário inválido.');
}

// Verifica se email já existe
$sql = $pdo->prepare("SELECT id FROM usuarios WHERE email = ?");
$sql->execute([$email]);
if ($sql->rowCount() > 0) {
    exit('Email já cadastrado.');
}

// Criptografa senha
$senha_hash = password_hash($senha, PASSWORD_DEFAULT);

$sql = $pdo->prepare("INSERT INTO usuarios (nome, email, senha, tipo) VALUES (?, ?, ?, ?)");
if ($sql->execute([$nome, $email, $senha_hash, $tipo])) {
    echo "Usuário cadastrado com sucesso! <a href='painel_admin.php'>Voltar</a>";
} else {
    echo "Erro ao cadastrar usuário.";
}
