<?php


include 'autentica.php';
if ($usuario['tipo'] != 'admin') exit('Acesso negado');
include 'conexao.php';
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <meta charset="UTF-8">
  <link rel="icon" type="image/png" href="img/favicon.png" />
  <link rel="shortcut icon" href="img/favicon.png" type="image/png" />
  <title>Painel do Administrador</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap + Font Awesome -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

  <style>
body {
  margin: 0;
  font-family: 'Segoe UI', sans-serif;
  background-color: #f1f3f5;
}

.sidebar {
  position: fixed;
  top: 0;
  left: 0;
  height: 100vh;
  width: 250px;
  background-color: #343a40;
  padding-top: 30px;
  color: white;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
}

.sidebar .menu-top {
  flex-grow: 1;
}

.sidebar h4 {
  text-align: center;
  margin-bottom: 30px;
  font-weight: 600;
}

.sidebar a {
  display: block;
  padding: 15px 20px;
  color: #ced4da;
  text-decoration: none;
  font-size: 16px;
  transition: background 0.2s;
}

.sidebar a:hover,
.sidebar a.active {
  background-color: #495057;
  color: #fff;
}

.sidebar a i {
  margin-right: 10px;
}

.main-content {
  margin-left: 250px;
  padding: 40px;
  position: relative;
}

.main-header {
  font-size: 28px;
  font-weight: 600;
  margin-bottom: 30px;
}

.card-info {
  padding: 25px;
  background: #fff;
  border-radius: 10px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.05);
  margin-bottom: 20px;
}

.logout-link {
  padding: 15px 20px;
  color: #dc3545;
  text-decoration: none;
  border-top: 1px solid #495057;
}

.logout-link:hover {
  background-color: #495057;
  color: #fff;
}

.profile-button {
  position: absolute;
  top: 20px;
  right: 40px;
}

.profile-button img {
  width: 45px;
  height: 45px;
  object-fit: cover;
  border-radius: 50%;
  cursor: pointer;
  border: 2px solid #ccc;
}

/* menu inferior mobile */
.menu-bottom {
  display: none;
}

.mobile-header {
  display: none;
}

@media (max-width: 768px) {
  .sidebar {
    display: none; /* esconde o menu lateral */
  }

  .main-content {
    margin-left: 0;
    padding: 20px;
  }

  .profile-button {
    right: 20px;
  }

  .menu-bottom {
    display: flex;
    justify-content: space-around;
    align-items: center;
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background-color: #343a40;
    border-top: 1px solid #495057;
    padding: 8px 0;
    z-index: 9999;
  }

  .menu-bottom a,
  .menu-bottom .dropdown-toggle {
    flex: 1;
    text-align: center;
    color: #ced4da;
    font-size: 14px;
    text-decoration: none;
  }

  .menu-bottom a:hover,
  .menu-bottom .dropdown-toggle:hover {
    color: #fff;
  }

  .menu-bottom i {
    display: block;
    font-size: 18px;
    margin-bottom: 3px;
  }

  /* dropdown dentro do menu inferior */
  .menu-bottom .dropdown-menu {
    position: absolute !important;
    bottom: 50px; /* sobe o dropdown acima da barra */
    transform: translateX(-50%);
    left: 50%;
  }

  /* header mobile */
  .mobile-header {
    display: block;
    text-align: center;
    padding: 10px;
    font-size: 18px;
    font-weight: 600;
    background-color: #fff;
    border-bottom: 1px solid #ccc;
    margin-bottom: 15px;
  }
}
  </style>
</head>
<body>

  <!-- Sidebar (desktop) -->
  <div class="sidebar">
    <div style="text-align: center; margin: 15px 30;">
      <img src="img/perfiladmin.png" alt="Perfil" id="fotoPerfilTopo" style="max-width: 130px; height: auto; border-radius: 8px; box-shadow: 0 2px 6px rgba(0,0,0,0.1);">
    </div>
      
    <div class="menu-top">
      <h4><i class="fas fa-user-shield"></i> Admin</h4>
      <div style="text-align: center; margin-top: 10px;">
        <p style="font-weight: bold; color: #acacb5;">
          Olá, <?php echo $_SESSION['usuario']['nome']; ?>
        </p>
      </div>

      <a href="#" id="botaoAbrirEntregas" data-bs-toggle="modal" data-bs-target="#modalEntregas">
        <i class="fas fa-truck"></i> Entregas
      </a>
      <a href="#" data-bs-toggle="modal" data-bs-target="#modalBairros">
        <i class="fas fa-map-marker-alt"></i> Bairros e Taxas
      </a>
      <a href="#" data-bs-toggle="modal" data-bs-target="#modalCadastro">
        <i class="fas fa-user-plus"></i> Cadastrar
      </a>
      <a href="#" data-bs-toggle="modal" data-bs-target="#modalUsuarios">
        <i class="fas fa-users-cog"></i> Gerenciar Usuários
      </a>
      <a href="#" data-bs-toggle="modal" data-bs-target="#modalAlerta" class="btn btn-link text-warning">
        <i class="fas fa-bell"></i> Cadastrar Alerta
      </a>
      <a href="logout.php" class="logout-link">
        <i class="fas fa-sign-out-alt"></i> Sair
      </a>
    </div>
  </div>

  <!-- Menu inferior (mobile) -->
  <div class="menu-bottom">
    <a href="#" id="botaoAbrirEntregas" data-bs-toggle="modal" data-bs-target="#modalEntregas">
      <i class="fas fa-truck"></i><span>Entregas</span>
    </a>
    <a href="#" data-bs-toggle="modal" data-bs-target="#modalBairros">
      <i class="fas fa-map-marker-alt"></i><span>Bairros</span>
    </a>
    <a href="#" data-bs-toggle="modal" data-bs-target="#modalCadastro">
      <i class="fas fa-user-plus"></i><span>Cadastrar</span>
    </a>
    <a href="#" data-bs-toggle="modal" data-bs-target="#modalUsuarios">
      <i class="fas fa-users-cog"></i><span>Usuários</span>
    </a>
    <a href="#" data-bs-toggle="modal" data-bs-target="#modalAlerta">
      <i class="fas fa-bell"></i><span>Alertas</span>
    </a>
  </div>

  <!-- Main content -->
  <div class="main-content">

    <!-- Header Mobile -->
    <div class="mobile-header">
      <i class="fas fa-tools me-2 text-primary"></i>Painel do Administrador
    </div>

    <!-- Botão de Perfil (desktop topo direito) -->
    <div class="dropdown profile-button">
      <a href="#" data-bs-toggle="dropdown" aria-expanded="false">
        <img src="img/perfiladmin.png" alt="Perfil" id="fotoPerfilTopo">
      </a>
      <ul class="dropdown-menu dropdown-menu-end shadow">
        <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#modalEditarPerfilAdmin">
          <i class="fas fa-user-edit me-2"></i>Editar Perfil
        </a></li>
        <li><a class="dropdown-item text-danger" href="logout.php">
          <i class="fas fa-sign-out-alt me-2"></i>Sair
        </a></li>
      </ul>
    </div>

    <div class="main-header d-none d-md-block">
      <i class="fas fa-tools me-2 text-primary"></i>Painel do Administrador
    </div>
<!-- Cards -->
<div class="row g-4">
  <div class="col-md-4">
    <div class="card h-100 border-0 shadow-sm rounded p-3">
      <div class="d-flex align-items-center mb-2">
        <i class="fas fa-truck fa-lg text-primary me-2"></i>
        <h5 class="mb-0">Entregas do Mês</h5>
      </div>
      <p>Total de entregas feitas:</p>
      <h4 class="text-primary">
        <strong id="total-entregas">0</strong>
      </h4>

      <!-- nova info de mensagens -->
      <p class="mt-3">Mensagens enviadas:</p>
      <h5 class="text-success">
        <strong id="total-mensagens">0</strong> / 1800
      </h5>
      <p class="mb-0"><small id="mensagens-percentual">0%</small></p>
    </div>
  </div>



      <div class="col-md-4">
        <div class="card h-100 border-0 shadow-sm rounded p-3">
          <div class="d-flex align-items-center mb-2">
            <i class="fas fa-wallet fa-lg text-secondary me-2"></i>
            <h5 class="mb-0">Receita e Lucro</h5>
          </div>
          <p><strong>Valor bruto:</strong> R$ <span id="total-taxas">0,00</span></p>
          <p><strong>Lucro:</strong> R$ <span id="lucro-admin">0,00</span></p>
        </div>
      </div>

      <div class="col-md-4">
        <div class="card h-100 border-0 shadow-sm rounded p-3">
          <div class="d-flex align-items-center mb-2">
            <i class="fas fa-user-plus fa-lg text-success me-2"></i>
            <h5 class="mb-0">Cadastros</h5>
          </div>
          <p><strong>Total:</strong> <span id="total-cadastros">0</span></p>
          <p><strong>Motoboys:</strong> <span id="cadastros-motoboy">0</span></p>
          <p><strong>Restaurantes:</strong> <span id="cadastros-restaurante">0</span></p>
        </div>
      </div>
    </div>

  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>











<!-- Modal para Gerenciar Usuários -->
<div class="modal fade gerenciar-usuarios-modal" id="modalUsuarios" tabindex="-1" aria-labelledby="modalUsuariosLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalUsuariosLabel">Gerenciar Usuários</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <table class="table">
          <thead>
            <tr>
              <th>ID</th>
              <th>Nome</th>
              <th>Email</th>
              <th>Tipo</th>
              <th>Status</th>
              <th>Ações</th>
            </tr>
          </thead>
          <tbody id="usuarioLista">
            <!-- Usuários serão carregados aqui -->
          </tbody>
        </table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
      </div>
    </div>
  </div>
</div>

<style>
  /* Estilo isolado para a Modal de Gerenciar Usuários */
  .gerenciar-usuarios-modal .modal-dialog {
    max-width: 1200px;
    margin: 30px auto;
  }

  @media (max-width: 768px) {
    .gerenciar-usuarios-modal .modal-dialog {
      max-width: 100%;  /* Modal vai ocupar toda a largura da tela em dispositivos pequenos */
    }
  }

  .gerenciar-usuarios-modal .modal-content {
    border-radius: 12px;
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.1);
    background-color: #fff;
    border: none;
    transition: transform 0.3s ease, opacity 0.3s ease;
  }

  .gerenciar-usuarios-modal .modal-header {
    background-color: #007bff;
    color: white;
    padding: 20px;
    border-top-left-radius: 12px;
    border-top-right-radius: 12px;
    display: flex;
    justify-content: space-between;
    align-items: center;
  }

  .gerenciar-usuarios-modal .modal-title {
    font-size: 1.6rem;
    font-weight: 600;
  }

  .gerenciar-usuarios-modal .btn-close {
    background: none;
    border: none;
    color: white;
    font-size: 1.5rem;
    cursor: pointer;
    opacity: 0.7;
  }

  .gerenciar-usuarios-modal .btn-close:hover {
    opacity: 1;
  }

  .gerenciar-usuarios-modal .modal-body {
    padding: 50px;
    max-height: 600px;
    overflow-y: auto; /* Habilita rolagem caso o conteúdo ultrapasse */
  }

  .gerenciar-usuarios-modal .table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 20px;
  }

  .gerenciar-usuarios-modal .table th, .gerenciar-usuarios-modal .table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #ddd;
  }

  .gerenciar-usuarios-modal .table th {
    background-color: #f4f6f9;
    color: #333;
    font-weight: 600;
  }

  .gerenciar-usuarios-modal .table tr:hover {
    background-color: #f1f1f1;
  }

  .gerenciar-usuarios-modal .table td {
    color: #555;
    font-size: 1rem;
  }

  /* Botões de ações */
  .gerenciar-usuarios-modal .btn-action {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 8px 15px;
    font-size: 0.9rem;
    border-radius: 5px;
    cursor: pointer;
    transition: background-color 0.3s ease;
  }

  .gerenciar-usuarios-modal .btn-action:hover {
    background-color: #0056b3;
  }

  .gerenciar-usuarios-modal .modal-footer {
    padding: 15px 20px;
    display: flex;
    justify-content: space-between;
  }

  .gerenciar-usuarios-modal .btn-secondary {
    background-color: #6c757d;
    border-color: #6c757d;
    padding: 10px 20px;
    font-size: 1rem;
    border-radius: 8px;
    transition: background-color 0.3s ease;
  }

  .gerenciar-usuarios-modal .btn-secondary:hover {
    background-color: #495057;
    border-color: #495057;
  }
  
  .gerenciar-usuarios-modal .modal-dialog {
  max-width: 1200px;
  margin: 30px auto;
  max-height: 80vh;   /* limite de altura relativo à tela */
}

.gerenciar-usuarios-modal .modal-content {
  max-height: 80vh;   /* limite no conteúdo */
  overflow: hidden;   /* impede transbordo */
}

.gerenciar-usuarios-modal .modal-body {
  padding: 30px;
  max-height: calc(80vh - 120px); /* altura - header/footer */
  overflow-y: auto;
}
</style>



<script>
    document.addEventListener('DOMContentLoaded', function () {
  // Carregar usuários ao abrir a modal
  $('#modalUsuarios').on('shown.bs.modal', function () {
    carregarUsuarios();
  });
});

function carregarUsuarios() {
  fetch('ADMIN/listar_usuarios.php')
    .then(response => response.json())
    .then(data => {
      const tabelaUsuarios = document.getElementById('usuarioLista');
      tabelaUsuarios.innerHTML = '';

      data.forEach(usuario => {
        let tr = document.createElement('tr');
        tr.innerHTML = `
          <td>${usuario.id}</td>
          <td>${usuario.nome}</td>
          <td>${usuario.email}</td>
          <td>${usuario.tipo}</td>
          <td>${usuario.status}</td>
          <td>
            <button class="btn btn-warning btn-sm me-1" onclick="editarUsuario(${usuario.id})">Editar</button>
            <button class="btn btn-danger btn-sm" onclick="excluirUsuario(${usuario.id})">Excluir</button>
          </td>
        `;
        tabelaUsuarios.appendChild(tr);
      });
    })
    .catch(error => console.log('Erro ao carregar usuários: ', error));
}

function excluirUsuario(id) {
  Swal.fire({
    title: 'Tem certeza?',
    text: "Você realmente deseja excluir este usuário?",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#d33',
    cancelButtonColor: '#6c757d',
    confirmButtonText: 'Sim, excluir',
    cancelButtonText: 'Cancelar'
  }).then((result) => {
    if (result.isConfirmed) {
      fetch('ADMIN/excluir_usuario.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'id=' + encodeURIComponent(id)
      })
      .then(response => response.json())
      .then(result => {
        if (result.sucesso) {
          Swal.fire({
            icon: 'success',
            title: 'Excluído!',
            text: 'O usuário foi marcado como excluído.',
            timer: 2000,
            showConfirmButton: false
          });
          carregarUsuarios(); // recarrega lista
        } else {
          Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: result.mensagem,
            timer: 2500,
            showConfirmButton: false
          });
        }
      })
      .catch(() => {
        Swal.fire({
          icon: 'error',
          title: 'Erro',
          text: 'Erro ao processar a requisição.',
          timer: 2500,
          showConfirmButton: false
        });
      });
    }
  });
}


</script>



<!-- Modal para Editar Usuário -->
<div class="modal fade" id="modalEditarUsuario" tabindex="-1" aria-labelledby="modalEditarUsuarioLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalEditarUsuarioLabel">Editar Usuário</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="formEditarUsuario">
          <input type="hidden" id="editarIdUsuario" name="id">
          
          <div class="mb-3">
            <label for="editarNome" class="form-label">Nome</label>
            <input type="text" class="form-control" id="editarNome" name="nome" required>
          </div>
          <div class="mb-3">
            <label for="editarEmail" class="form-label">Email</label>
            <input type="email" class="form-control" id="editarEmail" name="email" required>
          </div>
      <div class="mb-3">
  <label for="editarTipo" class="form-label">Tipo</label>
  <select class="form-control" id="editarTipo" name="tipo" required>
    <option value="motoboy">Motoboy</option>
    <option value="restaurante">Restaurante</option>
  </select>
</div>

          <div class="mb-3">
  <label for="editarStatus" class="form-label">Status</label>
  <select class="form-control" id="editarStatus" name="status" required>
    <option value="ATIVO">ATIVO</option>
    <option value="INATIVO">INATIVO</option>
  </select>
</div>

          <div class="mb-3">
            <label for="editarSenha" class="form-label">Nova Senha (Deixe em branco para não alterar)</label>
            <input type="password" class="form-control" id="editarSenha" name="senha">
          </div>
          <div class="mb-3">
            <label for="confirmarSenha" class="form-label">Confirmar Senha</label>
            <input type="password" class="form-control" id="confirmarSenha" name="confirmar_senha">
          </div>
          <button type="submit" class="btn btn-primary">Salvar Alterações</button>
        </form>
      </div>
    </div>
  </div>
</div>

<style>
  /* Estilos para a Modal de Editar Usuário */
  .modal.fade #modalEditarUsuario {
    display: none; /* Esconde a modal inicialmente */
    opacity: 0;
    transition: opacity 0.3s ease-in-out;
  }

  /* A modal aparece com transição suave */
  .modal.fade.show #modalEditarUsuario {
    display: block;
    opacity: 1;
  }

  /* Adicionando o desfoque ao fundo da página quando a modal está aberta */
  .modal-backdrop.show {
    backdrop-filter: blur(5px); /* Aplica desfoque no fundo */
    background-color: rgba(0, 0, 0, 0.5); /* Cor do fundo desfocado */
  }

  /* Estilo para o conteúdo da modal */
  .modal-dialog {
    max-width: 600px; /* Largura da modal */
    margin: 30px auto;
  }

  .modal-content {
    border-radius: 8px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
    background-color: #fff;
    border: none;
  }

  .modal-header {
    background-color: #007bff; /* Cor de fundo da cabeçalho */
    color: white;
    padding: 20px;
    border-top-left-radius: 8px;
    border-top-right-radius: 8px;
    display: flex;
    justify-content: space-between;
    align-items: center;
  }

  .modal-title {
    font-size: 1.5rem;
    font-weight: 600;
  }

  .btn-close {
    background: none;
    border: none;
    color: white;
    font-size: 1.5rem;
    cursor: pointer;
    opacity: 0.7;
  }

  .btn-close:hover {
    opacity: 1;
  }

  .modal-body {
    padding: 30px;
  }

  .form-label {
    font-weight: 500;
    color: #333;
  }

  .form-control {
    height: 40px;
    margin-bottom: 15px;
  }

  .btn-primary {
    background-color: #007bff;
    border-color: #007bff;
    padding: 8px 15px;
    font-size: 1rem;
    border-radius: 5px;
    cursor: pointer;
    transition: background-color 0.3s ease;
  }

  .btn-primary:hover {
    background-color: #0056b3;
    border-color: #0056b3;
  }

  /* Responsividade: Ajusta o tamanho da modal e dos campos em telas menores */
  @media (max-width: 768px) {
    .modal-dialog {
      max-width: 90%;  /* A modal ocupa mais espaço em telas pequenas */
    }

    .modal-title {
      font-size: 1.2rem;
    }

    .form-control {
      height: 35px;  /* Ajusta a altura dos campos */
    }
  }
</style>



<script>
  function editarUsuario(id) {
    // Fazer uma requisição para obter os dados do usuário
    fetch(`ADMIN/editar_usuario.php?id=${id}`)
      .then(response => response.json())
      .then(data => {
        // Preencher os campos da modal com os dados do usuário
        document.getElementById('editarIdUsuario').value = data.id;
        document.getElementById('editarNome').value = data.nome;
        document.getElementById('editarEmail').value = data.email;
        document.getElementById('editarTipo').value = data.tipo;
        document.getElementById('editarStatus').value = data.status;

        // Mostrar a modal
        $('#modalEditarUsuario').modal('show');
      })
      .catch(error => console.error('Erro ao carregar os dados do usuário:', error));
  }

  // Evento para quando o formulário de edição for enviado
  document.getElementById('formEditarUsuario').addEventListener('submit', function(event) {
    event.preventDefault();

    const formData = new FormData(this);

    fetch('ADMIN/editar_salvar.php', {
      method: 'POST',
      body: formData
    })
      .then(response => response.json())
      .then(data => {
        if (data.success) {
          // Fechar a modal e atualizar a lista de usuários
          $('#modalEditarUsuario').modal('hide');
          carregarUsuarios(); // Chama a função que carrega os usuários na tabela
          alert('Usuário atualizado com sucesso!');
        } else {
          alert('Erro: ' + data.error);
        }
      })
      .catch(error => console.error('Erro ao salvar alterações:', error));
  });
</script>

<!-- MODAL EDITAR PERFIL --->


<!-- Modal Editar Perfil Admin -->
<div class="modal fade" id="modalEditarPerfilAdmin" tabindex="-1" aria-labelledby="modalEditarPerfilAdminLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <form id="formEditarPerfilAdmin" method="POST" action="salvar_usuarioAdmin.php" enctype="multipart/form-data">
        <div class="modal-header">
          <h5 class="modal-title" id="modalEditarPerfilAdminLabel">
            <i class="fas fa-user-cog me-1"></i> Editar Perfil do Administrador
          </h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
        </div>
        
        <div class="modal-body">
          <!-- FOTO ATUAL -->
          <div class="text-center mb-3">
            <img src="img/perfiladmin.png" id="previewFoto" alt="Foto Atual" style="max-width: 160px; height: auto; border-radius: 8px; box-shadow: 0 2px 6px rgba(0,0,0,0.1);">
          </div>

<div class="mb-3">
  <label for="foto_admin" class="form-label">Alterar Foto de Perfil</label>
  <input type="file" class="form-control" id="foto_admin" name="foto" accept="image/*">
</div>

          <div class="mb-3">
            <label for="nome_admin" class="form-label">Nome</label>
            <input type="text" class="form-control" id="nome_admin" name="nome" required>
          </div>

          <div class="mb-3">
            <label for="email_admin" class="form-label">Email</label>
            <input type="email" class="form-control" id="email_admin" name="email" required>
          </div>

          <div class="mb-3">
            <label for="senha_admin" class="form-label">Senha</label>
            <input type="password" class="form-control" id="senha_admin" name="senha" placeholder="Deixe em branco para não alterar">
          </div>
        </div>
        
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save me-1"></i> Salvar Alterações
          </button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
            Cancelar
          </button>
        </div>
      </form>
    </div>
  </div>
</div>



<!-- SCRIPT DA MODAL EDITAR PERFI -->


<script>
document.addEventListener('DOMContentLoaded', function () {
  // Quando a modal for exibida, carregue os dados do perfil
  const modal = document.getElementById('modalEditarPerfilAdmin');
  modal.addEventListener('shown.bs.modal', function () {
    // Faz a requisição para obter os dados do perfil
    fetch('ADMIN/obter_perfilAdmin.php')  // Certifique-se de que este caminho esteja correto
      .then(response => {
        if (!response.ok) {
          throw new Error('Erro ao obter os dados do perfil.');
        }
        return response.json();
      })
      .then(data => {
        console.log(data); // Verifique os dados retornados no console

        // Preenche os campos com os dados do perfil
        if (data) {
          document.getElementById('nome_admin').value = data.nome || '';
          document.getElementById('email_admin').value = data.email || '';
          
          // Se houver foto de perfil, você pode definir a imagem com o caminho retornado no JSON
          if (data.foto) {
            document.getElementById('previewFoto').src = data.foto;
          }
        } else {
          alert('Dados do perfil não encontrados.');
        }
      })
      .catch(error => {
        console.error('Erro ao carregar os dados do perfil:', error);
        alert('Erro ao carregar dados do perfil.');
      });
  });

  // Quando o formulário for enviado, evita o envio padrão e realiza a requisição
  document.getElementById('formEditarPerfilAdmin').addEventListener('submit', function (e) {
    e.preventDefault();
    const form = e.target;
    const formData = new FormData(form);

    fetch('salvar_usuarioAdmin.php', {
      method: 'POST',
      body: formData
    })
    .then(res => res.text())
    .then(resposta => {
      alert(resposta);
      // Fecha a modal se quiser
      const modalInstance = bootstrap.Modal.getInstance(modal);
      if (modalInstance) modalInstance.hide();
    })
    .catch(error => {
      console.error('Erro ao salvar perfil:', error);
      alert('Erro ao salvar perfil.');
    });
  });
});


</script>


<script>
document.getElementById('formEditarPerfilAdmin').addEventListener('submit', function (e) {
  e.preventDefault();

  var form = document.getElementById('formEditarPerfilAdmin');
  var formData = new FormData(form);

  fetch('salvar_usuarioAdmin.php', {
    method: 'POST',
    body: formData
  })
  .then(response => response.text())
  .then(result => {
    if (result.includes('sucesso')) {
      // Fecha a modal
      var modal = bootstrap.Modal.getInstance(document.getElementById('modalEditarPerfilAdmin'));
      modal.hide();

      // Atualiza a imagem na página (evita cache)
      const imgElements = document.querySelectorAll('img[src*="img/perfiladmin.png"]');
      imgElements.forEach(img => {
        img.src = 'img/perfiladmin.png?' + new Date().getTime();
      });

      alert('Perfil atualizado com sucesso!');
    } else {
      alert(result); // Mostra erro vindo do PHP
    }
  })
  .catch(error => {
    console.error('Erro:', error);
    alert('Erro ao atualizar perfil.');
  });
});
</script>


<style>
  #modalEntregas .table-responsive {
    max-height: 400px;
    overflow-y: auto;
  }
</style>

<!-- Modal Entregas -->
<div class="modal fade" id="modalEntregas" tabindex="-1" aria-labelledby="modalEntregasLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="modalEntregasLabel">
          <i class="fas fa-truck me-2"></i>Gerenciar Entregas
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>

      <div class="modal-body">
        <!-- Filtros -->
        <div id="filtro-entregas" class="row g-2 mb-3 align-items-end">
          <div class="col-auto">
            <label for="filtro-data-inicio" class="form-label">Início:</label>
            <input type="date" id="filtro-data-inicio" class="form-control form-control-sm" style="width: 150px;">
          </div>
          <div class="col-auto">
            <label for="filtro-data-fim" class="form-label">Fim:</label>
            <input type="date" id="filtro-data-fim" class="form-control form-control-sm" style="width: 150px;">
          </div>
          <div class="col-auto">
            <label for="filtro-restaurante" class="form-label">Restaurante:</label>
            <select id="filtro-restaurante" class="form-select form-select-sm" style="width: 160px;">
              <option value="">Todos</option>
            </select>
          </div>
          <div class="col-auto">
            <label for="filtro-motoboy" class="form-label">Motoboy:</label>
            <select id="filtro-motoboy" class="form-select form-select-sm" style="width: 160px;">
              <option value="">Todos</option>
            </select>
            
            


            
          </div>
          <div class="col-auto d-flex gap-2">
            <button id="btn-filtrar" class="btn btn-sm btn-primary mt-2">
              <i class="fas fa-filter me-1"></i>Filtrar
            </button>
            <button id="btnGerarPDF" class="btn btn-sm btn-danger mt-2">
              <i class="fas fa-file-pdf me-1"></i>PDF
            </button>
          </div>
        </div>

        <!-- Tabela -->
        <div class="table-responsive">
          <table class="table table-sm table-bordered table-striped align-middle">
            <thead class="table-light">
              <tr>
                <th>ID</th>
                <th>Destino</th>
                <th>Status</th>
                <th>Restaurante</th>
                <th>Motoboy</th>
                <th>Data</th>
                <th>Taxa</th>
                <th>À pagar</th>
              </tr>
            </thead>
            <tbody id="lista-entregas">
              <!-- Populado via JS -->
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>



<script>
// Função para filtrar e carregar entregas

$(document).ready(function() {
  // Função para carregar entregas com filtros
  function carregarEntregas(restaurante_id = '', motoboy_id = '', data_inicio = '', data_fim = '') {
    $.getJSON('listar_entregas_admin.php', { restaurante_id, motoboy_id, data_inicio, data_fim }, function(data) {
      let html = '';
      data.forEach(e => {
        const liquido = (parseFloat(e.taxa) - 2).toFixed(2);
        html += `<tr>
          <td>${e.id}</td>
          <td>${e.destino}</td>
          <td>${e.status}</td>
          <td>${e.restaurante_nome || ''}</td>
          <td>${e.motoboy_nome || 'Aguardando'}</td>
          <td>${e.criado_em}</td>
          <td>R$ ${parseFloat(e.taxa).toFixed(2)}</td>
          <td>R$ ${liquido}</td>
        </tr>`;
      });
      $('#lista-entregas').html(html);
    });
  }

  // Evento para filtrar entregas (botão "Filtrar")
  $('#btn-filtrar').on('click', function() {
    const restaurante = $('#filtro-restaurante').val() || '';
    const motoboy = $('#filtro-motoboy').val() || '';
    const dataInicio = $('#filtro-data-inicio').val() || '';
    const dataFim = $('#filtro-data-fim').val() || '';

    carregarEntregas(restaurante, motoboy, dataInicio, dataFim);
  });
  
  
  

  // Evento para gerar PDF
  $('#btnGerarPDF').on('click', function() {
    const restaurante = $('#filtro-restaurante').val() || '';
    const motoboy = $('#filtro-motoboy').val() || '';
    const dataInicio = $('#filtro-data-inicio').val() || '';
    const dataFim = $('#filtro-data-fim').val() || '';

    const url = `apagar.php?restaurante_id=${encodeURIComponent(restaurante)}&motoboy_id=${encodeURIComponent(motoboy)}&data_inicio=${encodeURIComponent(dataInicio)}&data_fim=${encodeURIComponent(dataFim)}`;
    window.open(url, "_blank");
  });

  // Opcional: carregar todas entregas ao abrir a modal
  $('#modalEntregas').on('show.bs.modal', function () {
    carregarEntregas();
     carregarSelectUsuarios();
  });
});

function carregarSelectUsuarios() {
  $.getJSON('listar_usuariosADMIN.php?tipo=restaurante', function(data){
      let html = '', opt = '<option value="">Todos</option>';
      data.forEach(u => {
        html += `<tr><td>${u.id}</td><td>${u.nome}</td></tr>`;
        opt += `<option value="${u.id}">${u.nome}</option>`;
      });
      $('#lista-restaurantes').html(html);
      $('#filtro-restaurante').html(opt);
    });

    $.getJSON('listar_usuariosADMIN.php?tipo=motoboy', function(data){
      let html = '', opt = '<option value="">Todos</option>';
      data.forEach(u => {
        html += `<tr><td>${u.id}</td><td>${u.nome}</td></tr>`;
        opt += `<option value="${u.id}">${u.nome}</option>`;
      });
      $('#lista-motoboys').html(html);
      $('#filtro-motoboy').html(opt);
    });
  }


// Cria a instância só uma vez
const modalEntregasEl = document.getElementById('modalEntregas');
const modalEntregas = new bootstrap.Modal(modalEntregasEl);

document.getElementById('botaoAbrirEntregas').addEventListener('click', function () {
  modalEntregas.show();
});

// Evento para carregar entregas e filtros quando a modal for exibida
modalEntregasEl.addEventListener('shown.bs.modal', function () {
  carregarEntregas();
  carregarSelectUsuarios();
});

</script>
<style>
  /* Estilos para a Modal de Entregas */
  .modal-dialog.modal-xl {
    max-width: 1200px; /* Largura maior para a modal de entregas */
    margin: 30px auto;
  }

  /* Modal Content */
  .modal-content {
    border-radius: 10px;
    box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
    border: none;
    background-color: #fff;
  }

  /* Modal Header */
  .modal-header.bg-primary {
    background-color: #007bff; /* Cor de fundo */
    color: white; /* Cor do texto */
    padding: 20px;
    border-top-left-radius: 10px;
    border-top-right-radius: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
  }

  .modal-title {
    font-size: 1.5rem;
    font-weight: 600;
  }

  .modal-header .btn-close-white {
    color: white; /* Cor do ícone de fechar */
    font-size: 1.5rem;
  }

  /* Modal Body */
  .modal-body {
    padding: 30px;
    max-height: 70vh; /* Altura máxima da modal */
    overflow-y: auto; /* Permite rolar o conteúdo */
  }

  /* Filtros */
  #filtro-entregas {
    margin-bottom: 20px;
  }

  .form-label {
    font-weight: 500;
    color: #333;
  }

  .form-control-sm, .form-select-sm {
    height: 35px; /* Ajusta a altura dos campos de filtro */
  }

  #btn-filtrar, #btnGerarPDF {
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    font-size: 0.9rem;
  }

  #btn-filtrar {
    background-color: #007bff;
    border-color: #007bff;
  }

  #btn-filtrar:hover {
    background-color: #0056b3;
    border-color: #0056b3;
  }

  #btnGerarPDF {
    background-color: #dc3545;
    border-color: #dc3545;
  }

  #btnGerarPDF:hover {
    background-color: #c82333;
    border-color: #c82333;
  }

  .table-responsive {
    margin-top: 20px;
  }

  /* Tabela */
  .table {
    width: 100%;
    border-collapse: collapse;
    font-size: 0.9rem;
  }

  .table th, .table td {
    padding: 12px;
    text-align: center;
    vertical-align: middle;
  }

  .table th {
    background-color: #f8f9fa;
    font-weight: 600;
    color: #333;
  }

  .table td {
    color: #555;
  }

  .table-striped tbody tr:nth-child(odd) {
    background-color: #f2f2f2;
  }

  .table-bordered {
    border: 1px solid #dee2e6;
  }

  .table-bordered th, .table-bordered td {
    border: 1px solid #dee2e6;
  }

  .table-sm td, .table-sm th {
    padding: 8px; /* Ajusta o padding para tabelas menores */
  }

  /* Estilos de Botões dentro da Tabela */
  .btn-action {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 6px 12px;
    font-size: 0.85rem;
    border-radius: 5px;
    cursor: pointer;
    transition: background-color 0.3s ease;
  }

  .btn-action:hover {
    background-color: #0056b3;
  }

  /* Responsividade para dispositivos pequenos */
  @media (max-width: 768px) {
    .modal-dialog.modal-xl {
      max-width: 100%;
    }

    .modal-header .modal-title {
      font-size: 1.3rem;
    }

    .table th, .table td {
      font-size: 0.85rem; /* Ajusta o tamanho da fonte na tabela em dispositivos pequenos */
    }

    #btn-filtrar, #btnGerarPDF {
      font-size: 0.8rem; /* Ajusta o tamanho do botão em telas menores */
    }
  }
</style>

<!-- script modal entregas -->





<!-- MODAL CADASTRAR BAIRRO E TAXA -->
<!-- Modal Bairros e Taxas -->
<div class="modal fade" id="modalBairros" tabindex="-1" aria-labelledby="modalBairrosLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="modalBairrosLabel"><i class="fas fa-map-marker-alt me-2"></i>Bairros e Taxas</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <div class="modal-body">

        <form id="form-cadastrar-bairro" class="form-section" style="max-width: 100%;">
          <div class="row g-2 align-items-end">

            <div class="col-sm-4">
              <label for="estabelecimento_id" class="form-label">Estab.</label>
              <select name="estabelecimento_id" id="estabelecimento_id" class="form-select form-select-sm" required>
                <!-- Opções carregadas via AJAX -->
              </select>
            </div>

            <div class="col-sm-4">
              <label for="nome_bairro" class="form-label">Bairro:</label>
              <select name="nome_bairro" id="nome_bairro" class="form-control form-control-sm" required>
                <option value="">Selecione um Bairro</option>
                <option value="Aeroporto">Aeroporto</option>
                <option value="Alto Bonito">Alto Bonito</option>
                <option value="Berger">Berger</option>
                <option value="Bom Jesus">Bom Jesus</option>
                <option value="Bom Sucesso">Bom Sucesso</option>
                <option value="Centro">Centro</option>
                
                <option value="Der Figueroa">Der Figueroa</option>
                <option value="Gioppo">Gioppo</option>
                <option value="Industrial">Industrial</option>
                <option value="Kurtz">Kurtz</option>
                <option value="Martello">Martello</option>
                <option value="Nossa Senhora Salete">Nossa Senhora Salete</option>
                <option value="Paraíso">Paraíso</option>
                <option value="Rancho Fundo">Rancho Fundo</option>
                <option value="Reunidas">Reunidas</option>
                <option value="Santa Catarina">Santa Catarina</option>
                <option value="São Cristóvão">São Cristóvão</option>
              </select>
            </div>

            <div class="col-sm-2">
              <label for="taxa" class="form-label">Taxa (R$):</label>
              <input type="number" step="0.01" min="0" name="taxa" id="taxa" class="form-control form-control-sm" required>
            </div>

            <div class="col-sm-2 d-flex justify-content-end">
              <input type="hidden" name="id_taxa" id="id_taxa">
              <button type="submit" class="btn btn-primary btn-sm me-2">Salvar</button>
              <button type="button" id="btn-cancelar-edicao" style="display:none;" class="btn btn-secondary btn-sm">Cancelar</button>
            </div>

          </div>
        </form>

        <hr>

        <!-- Campo de pesquisa para a tabela -->
        <div class="mb-3">
          <label for="searchEstabelecimento" class="form-label">Pesquisar Estabelecimento:</label>
          <input type="text" id="searchEstabelecimento" class="form-control" placeholder="Digite para pesquisar...">
        </div>

        <div class="table-responsive">
          <table class="table table-bordered table-striped table-sm" id="tabela-bairros">
            <thead>
              <tr>
                <th>Estabelecimento</th>
                <th>Bairro</th>
                <th>Taxa (R$)</th>
                <th>Ações</th>
              </tr>
            </thead>
            <tbody>
              <!-- conteúdo via AJAX -->
            </tbody>
          </table>
        </div>

      </div>
    </div>
  </div>
</div>

<!-- Script para filtrar a tabela -->
<script>
  // Função para filtrar a tabela com base no que é digitado no campo de pesquisa
  document.getElementById('searchEstabelecimento').addEventListener('input', function() {
    var filter = this.value.toUpperCase();
    var table = document.getElementById('tabela-bairros');
    var rows = table.getElementsByTagName('tr');

    for (var i = 1; i < rows.length; i++) {
      var td = rows[i].getElementsByTagName('td')[0]; // A primeira coluna é o nome do Estabelecimento
      if (td) {
        var txtValue = td.textContent || td.innerText;
        if (txtValue.toUpperCase().indexOf(filter) > -1) {
          rows[i].style.display = '';
        } else {
          rows[i].style.display = 'none';
        }
      }
    }
  });
</script>





<!--- SCRIPT BAIROS E TAXAS -->

<script>
$(function () {
  function carregarEstabelecimentos() {
    $.ajax({
      url: 'listar_estabelecimentos.php',
      dataType: 'json',
      success: function(res) {
        if (res.status === 'success') {
          let options = '<option value="">Selecione</option>';
          res.data.forEach(e => {
            options += `<option value="${e.id}">${e.nome}</option>`;
          });
          $('#estabelecimento_id').html(options);
        } else {
          Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: 'Erro ao carregar estabelecimentos',
            timer: 2500,
            showConfirmButton: false
          });
        }
      }
    });
  }

  function listarTaxas() {
    $.ajax({
      url: 'listar_taxas.php',
      dataType: 'json',
      success: function(res) {
        if (res.status === 'success') {
          let linhas = '';
          res.data.forEach(taxa => {
            linhas += `<tr>
              <td>${taxa.estabelecimento_nome}</td>
              <td>${taxa.nome_bairro}</td>
              <td>R$ ${parseFloat(taxa.taxa).toFixed(2).replace('.', ',')}</td>
              <td>
                <button class="btn btn-sm btn-info btn-editar" data-id="${taxa.id}"><i class="fa fa-edit"></i></button>
                <button class="btn btn-sm btn-danger btn-excluirt" data-id="${taxa.id}"><i class="fa fa-trash"></i></button>
              </td>
            </tr>`;
          });
          $('#tabela-bairros tbody').html(linhas);
        } else {
          Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: 'Erro ao listar taxas',
            timer: 2500,
            showConfirmButton: false
          });
        }
      }
    });
  }

  function resetForm() {
    $('#form-cadastrar-bairro')[0].reset();
    $('#id_taxa').val('');
    $('#btn-cancelar-edicao').hide();
  }

  $('#form-cadastrar-bairro').on('submit', function (e) {
    e.preventDefault();
    $.ajax({
      url: 'salvar_taxas.php',
      type: 'POST',
      data: $(this).serialize(),
      dataType: 'json',
      success: function (res) {
        if (res.status === 'success') {
          Swal.fire({
            icon: 'success',
            title: 'Sucesso',
            text: res.msg,
            timer: 2000,
            showConfirmButton: false
          });
          resetForm();
          listarTaxas();
        } else {
          Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: res.msg,
            timer: 2500,
            showConfirmButton: false
          });
        }
      },
      error: function () {
        Swal.fire({
          icon: 'error',
          title: 'Erro',
          text: 'Erro na requisição.',
          timer: 2500,
          showConfirmButton: false
        });
      }
    });
  });

  $('#btn-cancelar-edicao').on('click', function () {
    resetForm();
  });

  $('#tabela-bairros').on('click', '.btn-editar', function () {
    let id = $(this).data('id');
    $.ajax({
      url: 'listar_taxas.php',
      data: { id: id },
      dataType: 'json',
      success: function (res) {
        if (res.status === 'success' && res.data.length === 1) {
          const taxa = res.data[0];
          $('#estabelecimento_id').val(taxa.estabelecimento_id);
          $('#nome_bairro').val(taxa.nome_bairro);
          $('#taxa').val(taxa.taxa);
          $('#id_taxa').val(taxa.id);
          $('#btn-cancelar-edicao').show();
        } else {
          Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: 'Taxa não encontrada',
            timer: 2500,
            showConfirmButton: false
          });
        }
      }
    });
  });

  $('#tabela-bairros').on('click', '.btn-excluirt', function () {
    let id = $(this).data('id');

    Swal.fire({
      title: 'Tem certeza?',
      text: "Você realmente deseja excluir esta taxa?",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#6c757d',
      confirmButtonText: 'Sim, excluir',
      cancelButtonText: 'Cancelar'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: 'excluir_taxas.php',
          type: 'POST',
          data: { id: id },
          dataType: 'json',
          success: function (res) {
            if (res.status === 'success') {
              Swal.fire({
                icon: 'success',
                title: 'Excluída!',
                text: res.msg,
                timer: 2000,
                showConfirmButton: false
              });
              listarTaxas();
            } else {
              Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: res.msg,
                timer: 2500,
                showConfirmButton: false
              });
            }
          },
          error: function () {
            Swal.fire({
              icon: 'error',
              title: 'Erro',
              text: 'Erro na requisição.',
              timer: 2500,
              showConfirmButton: false
            });
          }
        });
      }
    });
  });

  // Só carrega dados ao abrir a modal
  $('#modalBairros').on('shown.bs.modal', function () {
    carregarEstabelecimentos();
    listarTaxas();
    resetForm();
  });
});
</script>


<!--- MODAL CADASTRAR USUARIO -->

<!-- Modal Cadastro Usuário -->
<div class="modal fade" id="modalCadastro" tabindex="-1" aria-labelledby="modalCadastroLabel" aria-hidden="true">
  <div class="modal-dialog modal-md modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="modalCadastroLabel"><i class="fas fa-user-plus me-2"></i>Cadastrar Novo Usuário</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <div class="modal-body">

        <form id="form-cadastrar-usuario" class="mb-3">
          <div class="mb-2">
            <label for="nome" class="form-label">Nome:</label>
            <input type="text" id="nome" name="nome" class="form-control form-control-sm" required>
          </div>
          <div class="mb-2">
            <label for="email" class="form-label">Email:</label>
            <input type="email" id="email" name="email" class="form-control form-control-sm" required>
          </div>
          <div class="mb-2">
            <label for="tipo" class="form-label">Tipo:</label>
            <select id="tipo" name="tipo" class="form-select form-select-sm" required>
              <option value="">Selecione</option>
              <option value="restaurante">Restaurante</option>
              <option value="motoboy">Motoboy</option>
            </select>
          </div>
          <div class="mb-3">
            <label for="senha" class="form-label">Senha:</label>
            <input type="password" id="senha" name="senha" class="form-control form-control-sm" required>
          </div>
          <button type="submit" class="btn btn-primary btn-sm">Cadastrar</button>
        </form>

        <div id="msg-cadastro" class="small text-success"></div>

      </div>
    </div>
  </div>
</div>

<!-- SCRIPT MODAL CADASTRO USUARIO -->


<script>
document.getElementById('form-cadastrar-usuario').addEventListener('submit', function(e) {
  e.preventDefault();

  const form = e.target;
  const dados = new FormData(form);

  fetch('salvar_user.php', {
    method: 'POST',
    body: dados
  })
  .then(res => res.text())
  .then(resposta => {
    if (resposta.includes("sucesso")) {
      // reseta o form
      form.reset();

      // fecha a modal de cadastro
      const modalEl = document.getElementById('modalCadastro');
      const modal = bootstrap.Modal.getInstance(modalEl) || new bootstrap.Modal(modalEl);
      modal.hide();

      // alerta de sucesso
      Swal.fire({
        icon: 'success',
        title: 'Usuário cadastrado!',
        text: 'O novo usuário foi criado com sucesso.',
        timer: 3000,
        showConfirmButton: false
      });

      // recarrega lista, se existir
      if (typeof carregarUsuarios === "function") {
        carregarUsuarios();
      }

    } else {
      // alerta de erro
      Swal.fire({
        icon: 'error',
        title: 'Erro',
        text: resposta,
        timer: 2500,
        showConfirmButton: false
      });
    }
  })
  .catch(() => {
    Swal.fire({
      icon: 'error',
      title: 'Erro',
      text: 'Erro ao enviar formulário.',
      timer: 2500,
      showConfirmButton: false
    });
  });
});
</script>











<!--- SCRIPTS CARDS ---> 

<script>
function carregarTotalEntregasMes() {
  $.getJSON('somar_entregas.php', function(res) {
    // total de entregas
    $('#total-entregas').text(res.total);

    // total de mensagens (2x entregas)
    let totalMensagens = parseInt(res.total) * 2;
    $('#total-mensagens').text(totalMensagens);

    // calcula percentual
    let percentual = (totalMensagens / 1800) * 100;
    if (percentual > 100) percentual = 100; // trava no 100%
    $('#mensagens-percentual').text(percentual.toFixed(1) + "%");

    // alerta se atingir 100%
    if (totalMensagens >= 1800) {
      alert("⚠️ Limite de 1800 mensagens atingido!");
    }
  });
}

// Atualiza ao abrir a página
carregarTotalEntregasMes();

// Atualiza a cada 2 segundos
setInterval(carregarTotalEntregasMes, 2000);
</script>

<script>
function carregarSomarLucro() {
  $.getJSON('somarlucro.php', function(res) {
    $('#total-taxas').text(res.total_taxas ?? '0,00');
    $('#lucro-admin').text(res.lucro ?? '0,00');
  }).fail(function() {
    $('#total-taxas').text('0,00');
    $('#lucro-admin').text('0,00');
  });
}

// Atualiza ao carregar a página
carregarSomarLucro();

// Atualiza a cada 2 segundos (2000 ms)
setInterval(carregarSomarLucro, 2000);
</script>

<script>
function carregarCadastros() {
  $.getJSON('contar_cadastros.php', function(res) {
    $('#total-cadastros').text(res.total ?? 0);
    $('#cadastros-motoboy').text(res.motoboy ?? 0);
    $('#cadastros-restaurante').text(res.restaurante ?? 0);
  }).fail(function() {
    $('#total-cadastros').text('0');
    $('#cadastros-motoboy').text('0');
    $('#cadastros-restaurante').text('0');
  });
}

// Carrega ao abrir a página
carregarCadastros();

// Atualiza a cada 2 segundos (opcional)
setInterval(carregarCadastros, 2000);
</script>

<style>
.footer-modern {
  justify-content: flex-start;
  padding-left: 400px; /* espaço pro conteúdo no desktop */
  position: fixed;
  bottom: 0;
  left: 250px; /* largura da sidebar */
  width: calc(100% - 250px);
  height: 48px;
  background: linear-gradient(90deg, #343a40 0%, #212529 100%);
  color: #f8f9fa;
  display: flex;
  align-items: center;
  font-size: 14px;
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  z-index: 999;
  box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.2);
}

.footer-modern a {
  color: #0d6efd;
  font-weight: 600;
  text-decoration: none;
  transition: color 0.3s ease;
}

.footer-modern a:hover {
  color: #66b2ff;
  text-decoration: underline;
}

.footer-modern i {
  margin-right: 6px;
  color: #ffc107;
}

/* mobile */
@media (max-width: 768px) {
  .footer-modern {
    position: relative; /* deixa de ser fixo pra não colidir com o menu-bottom */
    bottom: auto;
    left: 0;
    width: 100%;
    height: auto;
    padding: 10px;
    justify-content: center;
    text-align: center;
    font-size: 13px;
    box-shadow: none;
    background: #212529; /* deixa mais clean no mobile */
    margin-bottom: 60px; /* espaço pra não colar no menu-bottom */
  }
}

/* exceção PWA */
@media all and (display-mode: standalone) {
  .footer-modern {
    background: transparent !important; /* remove fundo */
    box-shadow: none !important;        /* remove sombra */
    color: #161717 !important;          /* deixa só o texto visível */
    justify-content: center !important;
    padding: 10px !important;
    margin-bottom: 0 !important;
    height: auto !important;
    position: fixed !important;
    bottom: 0 !important;
    left: 0 !important;
    width: 100% !important;
  }

  .footer-modern a {
    color: #161717 !important; /* links também só em branco */
  }

  .footer-modern a:hover {
    color: #ffc107 !important; /* hover em amarelo */
  }

  .footer-modern i {
    color: #ffc107 !important; /* ícone continua visível */
  }
}
</style>

<footer class="footer-modern">
  <i class="fas fa-shield-alt"></i>
  &copy; 2025 <a href="https://advopack.net" target="_blank"> ADVOPACK</a> – Todos os direitos reservados.
</footer>

<!-- Font Awesome para ícone -->

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
  /* Limita a altura da modal-body e adiciona scroll vertical */
  #modalRelatorios .modal-body {
    max-height: 400px; /* ajuste a altura conforme desejar */
    overflow-y: auto;
  }
  /* Espaço para o campo de busca */
  #modalRelatorios .busca-container {
    margin-bottom: 1rem;
  }
</style>

<!-- Modal Status Usuários -->
<div class="modal fade" id="modalRelatorios" tabindex="-1" aria-labelledby="modalRelatoriosLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalRelatoriosLabel">Alterar Status dos Usuários</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <div class="modal-body">
        <!-- Campo de busca -->
        <div class="busca-container">
          <input type="text" id="buscarUsuarioStatus" class="form-control" placeholder="Buscar por nome...">
        </div>
        <div id="listaUsuariosStatus">
          <!-- Lista de usuários será carregada aqui via AJAX -->
          Carregando...
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
      </div>
    </div>
  </div>
</div>

<script>
(() => {
  const modalRelatorios = document.getElementById('modalRelatorios');
  const inputBusca = document.getElementById('buscarUsuarioStatus');
  const divLista = document.getElementById('listaUsuariosStatus');

  // Quando a modal abrir
  modalRelatorios.addEventListener('show.bs.modal', () => {
    inputBusca.value = ''; // limpa busca
    carregarUsuarios();
  });

  // Listener de busca (só uma vez)
  inputBusca.addEventListener('input', () => {
    filtrarUsuariosStatus(inputBusca.value);
  });

  function carregarUsuarios() {
    fetch('consultarstatus.php')
      .then(response => response.text())
      .then(html => {
        divLista.innerHTML = html;

        divLista.querySelectorAll('.select-status-usuario').forEach(select => {
          select.addEventListener('change', function() {
            const usuarioId = this.dataset.usuarioId;
            const novoStatus = this.value;
            alterarStatusUsuario(usuarioId, novoStatus);
          });
        });

        filtrarUsuariosStatus(inputBusca.value);
      })
      .catch(err => {
        divLista.innerHTML = 'Erro ao carregar usuários.';
        console.error(err);
      });
  }

  function alterarStatusUsuario(usuarioId, novoStatus) {
    fetch('alterarstatus.php', {
      method: 'POST',
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: `id=${encodeURIComponent(usuarioId)}&status=${encodeURIComponent(novoStatus)}`
    })
    .then(response => response.json())
    .then(data => {
      if (data.sucesso) {
        alert(`Status do usuário atualizado para: ${novoStatus}`);
      } else {
        alert('Erro ao atualizar status: ' + data.mensagem);
      }
    })
    .catch(err => {
      alert('Erro ao atualizar status.');
      console.error(err);
    });
  }

  function filtrarUsuariosStatus(textoBusca) {
    textoBusca = textoBusca.toLowerCase();
    const tabela = divLista.querySelector('table');
    if (!tabela) return;

    const linhas = tabela.querySelectorAll('tbody tr');
    linhas.forEach(linha => {
      const nome = linha.querySelector('td').textContent.toLowerCase();
      linha.style.display = nome.includes(textoBusca) ? '' : 'none';
    });
  }
})();
</script>


<!-- MODAL ALERTA -->

<!-- Modal -->
<div class="modal fade" id="modalAlerta" tabindex="-1" aria-labelledby="modalAlertaLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable"> <!-- modal-lg para mais espaço e scroll automático -->
    <div class="modal-content shadow-sm border-0 rounded-4">

      <div class="modal-header bg-warning text-dark d-flex justify-content-between align-items-center rounded-top-4 shadow-sm">
        <h5 class="modal-title fw-bold" id="modalAlertaLabel" style="letter-spacing: 0.05em;">Alertas</h5>
        <div>
          <button type="button" class="btn btn-primary btn-sm me-2" id="btnNovoAlerta" onclick="toggleFormAlerta()">
            <i class="bi bi-plus-lg"></i> Novo Alerta
          </button>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
        </div>
      </div>

      <div class="modal-body p-4" style="background: #fff;">

        <!-- Lista de alertas com barra de rolagem -->
        <div id="listaAlertas" class="mb-4" style="max-height: 320px; overflow-y: auto; padding-right: 8px;">
          <p class="text-muted fst-italic text-center">Carregando alertas...</p>
        </div>

        <!-- Formulário de criação/edição de alerta (inicialmente oculto) -->
        <div id="formAlertaContainer" style="display:none;">
          <div id="msgAlerta" class="mb-3"></div>
          <form id="formAlerta" autocomplete="off">
            <div class="mb-3">
              <label for="titulo" class="form-label fw-semibold">Título</label>
              <input type="text" class="form-control form-control-lg rounded-3" id="titulo" name="titulo" placeholder="Título do alerta" required>
            </div>
            <div class="mb-4">
              <label for="mensagem" class="form-label fw-semibold">Mensagem</label>
              <textarea class="form-control form-control-lg rounded-3" id="mensagem" name="mensagem" rows="4" placeholder="Mensagem do alerta" required></textarea>
            </div>
            <div class="text-end">
              <button type="submit" class="btn btn-success btn-lg px-4 rounded-pill shadow-sm">
                <i class="bi bi-check-lg"></i> Salvar
              </button>
              <button type="button" class="btn btn-outline-secondary btn-lg ms-3 px-4 rounded-pill" onclick="toggleFormAlerta()">
                Cancelar
              </button>
            </div>
          </form>
        </div>

      </div>
    </div>
  </div>
</div>

<!-- Ícones Bootstrap (opcional, para os ícones de botão) -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
  /* Scrollbar estilizada para a lista */
  #listaAlertas::-webkit-scrollbar {
    width: 8px;
  }
  #listaAlertas::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
  }
  #listaAlertas::-webkit-scrollbar-thumb {
    background-color: #ffc107; /* amarelo warning */
    border-radius: 4px;
  }

  /* Estilo dos alertas */
  #listaAlertas .alert {
    border-radius: 12px;
    box-shadow: 0 2px 6px rgb(0 0 0 / 0.1);
    font-size: 0.95rem;
    padding: 1rem 1.25rem;
    margin-bottom: 1rem;
    transition: background-color 0.3s ease;
  }
  #listaAlertas .alert-warning {
    background-color: #fff3cd;
    border-color: #ffeeba;
    color: #856404;
  }
  #listaAlertas .alert-secondary {
    background-color: #e2e3e5;
    border-color: #d3d6d8;
    color: #41464b;
  }
  #listaAlertas .alert:hover {
    background-color: #fff8e1;
  }

  /* Botão desativar com hover */
  #listaAlertas button.btn-outline-danger {
    min-width: 100px;
    border-radius: 20px;
    font-weight: 600;
    transition: background-color 0.3s ease, color 0.3s ease;
  }
  #listaAlertas button.btn-outline-danger:hover:not(:disabled) {
    background-color: #dc3545;
    color: #fff;
  }
  #listaAlertas button:disabled {
    opacity: 0.5;
    cursor: not-allowed;
  }
</style>

<!-- SCRIPT ALERTA -->

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function carregarAlertas() {
  $("#listaAlertas").html('<p class="text-muted">Carregando alertas...</p>');
  $.ajax({
    url: 'listar_alertas.php',
    method: 'GET',
    dataType: 'json',
    success: function(response) {
      if(response.status === 'ok') {
        let alertas = response.alertas;
        if (alertas.length === 0) {
          $("#listaAlertas").html('<p class="text-muted">Nenhum alerta cadastrado.</p>');
          return;
        }
        let html = '';
        alertas.forEach(function(alerta) {
          let desativado = alerta.ativo == 0 ? 'disabled' : '';
          let classe = alerta.ativo == 1 ? 'alert-warning' : 'alert-secondary';
          html += `
            <div class="alert ${classe} d-flex justify-content-between align-items-start">
              <div>
                <strong>${alerta.titulo}</strong><br>
                <small>${alerta.mensagem}</small><br>
                <small class="text-muted"><i>Criado em: ${alerta.data_criacao}</i></small>
              </div>
              <button class="btn btn-sm btn-outline-danger" onclick="desativarAlerta(${alerta.id})" ${desativado}>
                ${alerta.ativo == 1 ? 'Desativar' : 'Desativado'}
              </button>
            </div>
          `;
        });
        $("#listaAlertas").html(html);
      } else {
        $("#listaAlertas").html('<p class="text-danger">Erro ao carregar alertas: ' + response.msg + '</p>');
      }
    },
    error: function() {
      $("#listaAlertas").html('<p class="text-danger">Erro na requisição AJAX.</p>');
    }
  });
}

function desativarAlerta(id) {
  if (!confirm("Deseja realmente desativar este alerta?")) return;

  $.ajax({
    url: 'desativar_alerta.php',
    method: 'POST',
    data: {id: id},
    dataType: 'json',
    success: function(response) {
      if(response.status === 'ok') {
        carregarAlertas();
        alert('Alerta desativado com sucesso!');
      } else {
        alert('Erro ao desativar alerta: ' + response.msg);
      }
    },
    error: function() {
      alert('Erro na requisição AJAX.');
    }
  });
}

function toggleFormAlerta() {
  let formContainer = $("#formAlertaContainer");
  let lista = $("#listaAlertas");
  let btnNovo = $("#btnNovoAlerta");

  if(formContainer.is(':visible')) {
    formContainer.hide();
    lista.show();
    btnNovo.text('Novo Alerta');
    $("#formAlerta")[0].reset();
    $("#msgAlerta").html('');
  } else {
    formContainer.show();
    lista.hide();
    btnNovo.text('Fechar Formulário');
  }
}

// Usar seu script de salvar alerta já existente
$(document).ready(function() {
  carregarAlertas();

  $("#formAlerta").on("submit", function(e){
    e.preventDefault();

    $.ajax({
      url: "salvar_alerta.php",
      method: "POST",
      data: $(this).serialize(),
      success: function(retorno){
        if (retorno.trim() === "ok") {
          $("#msgAlerta").html('<div class="alert alert-success">Alerta cadastrado com sucesso!</div>');
          $("#formAlerta")[0].reset();
          carregarAlertas();
          toggleFormAlerta();
        } else {
          $("#msgAlerta").html('<div class="alert alert-danger">' + retorno + '</div>');
        }
      },
      error: function(){
        $("#msgAlerta").html('<div class="alert alert-danger">Erro na requisição AJAX.</div>');
      }
    });
  });
});
</script>