<?php

session_start();
include 'conexao.php';

// Se já estiver logado, redireciona
if (isset($_SESSION['usuario'])) {
    $tipo = $_SESSION['usuario']['tipo'];
    header("Location: painel_$tipo.php");
    exit;
}

// Tentativa de login automático via cookie
if (!isset($_SESSION['usuario']) && isset($_COOKIE['login_token'])) {
    $token = $_COOKIE['login_token'];
    $sql = $pdo->prepare("SELECT * FROM usuarios WHERE token_login = ?");
    $sql->execute([$token]);
    $usuario = $sql->fetch();

    if ($usuario && $usuario['status'] === 'ATIVO') {
        $_SESSION['usuario'] = $usuario;
        header("Location: painel_{$usuario['tipo']}.php");
        exit;
    } else {
        // Token inválido, apaga cookie
        setcookie('login_token', '', time() - 3600, "/");
    }
}


$msgErro = '';
if ($_POST) {
    $nome = $_POST['nome'];
    $senha = $_POST['senha'];
    $lembrar = isset($_POST['lembrar']);

    $sql = $pdo->prepare("SELECT * FROM usuarios WHERE nome = ?");
    $sql->execute([$nome]);
    $usuario = $sql->fetch();

    if ($usuario && password_verify($senha, $usuario['senha'])) {
        if ($usuario['status'] === 'ATIVO') {
            $_SESSION['usuario'] = $usuario;

            // Se "lembrar-me" estiver marcado, cria cookie com token
            if ($lembrar) {
                $token = bin2hex(random_bytes(32)); // Token aleatório seguro

                // Define cookie para durar 30 dias
                setcookie('login_token', $token, time() + (86400 * 30), "/");

                // Atualiza o token no banco
                $stmt = $pdo->prepare("UPDATE usuarios SET token_login = ? WHERE id = ?");
                $stmt->execute([$token, $usuario['id']]);
            }

            header("Location: painel_{$usuario['tipo']}.php");
            exit;
        } else {
            $msgErro = "Seu usuário está inativo, consulte o responsável pelo sistema.";
        }
    } else {
        $msgErro = "Login inválido: nome ou senha incorretos.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
<link rel="manifest" href="https://progressier.app/MAlTMYQAYjwc0m0Bk2SX/progressier.json"/><script defer src="https://progressier.app/MAlTMYQAYjwc0m0Bk2SX/script.js"></script>  
  <title>Chama Ai - Login</title>
  <link rel="icon" type="image/png" href="img/favicon.png" />
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />

  <style>
    * { margin:0; padding:0; box-sizing:border-box; font-family:'Poppins',sans-serif; }
    body {
      height:100vh;
      display:flex;
      align-items:center;
      justify-content:center;
      background:#0d0d0d;
      overflow:hidden;
      position:relative;
    }

    /* fundo com gradiente animado */
    body::before {
      content:"";
      position:absolute;
      top:0; left:0; width:100%; height:100%;
      background: linear-gradient(-45deg, #0080ff, #ffbb0f, #1e1e2f, #27293d);
      background-size: 400% 400%;
      animation: gradientBG 12s ease infinite;
      z-index:-2;
    }
    @keyframes gradientBG {
      0% {background-position:0% 50%;}
      50% {background-position:100% 50%;}
      100% {background-position:0% 50%;}
    }

    /* partículas leves (simulando faróis/movimento) */
    .particle {
      position:absolute;
      width:6px; height:6px;
      background:rgba(255,255,255,0.6);
      border-radius:50%;
      animation: float 10s linear infinite;
    }
    .particle:nth-child(1){ top:20%; left:10%; animation-delay:0s;}
    .particle:nth-child(2){ top:60%; left:30%; animation-delay:2s;}
    .particle:nth-child(3){ top:40%; left:70%; animation-delay:4s;}
    .particle:nth-child(4){ top:80%; left:50%; animation-delay:6s;}
    .particle:nth-child(5){ top:30%; left:90%; animation-delay:8s;}

    @keyframes float {
      0% {transform:translateY(0) scale(1);}
      50% {transform:translateY(-30px) scale(1.2);}
      100% {transform:translateY(0) scale(1);}
    }

    .login-container {
      background: rgba(255,255,255,0.08);
      border-radius:20px;
      padding:40px 30px;
      max-width:380px;
      width:90%;
      text-align:center;
      backdrop-filter: blur(15px) saturate(180%);
      box-shadow:0 0 40px rgba(0,0,0,0.6);
      animation: fadeIn 1s ease-in-out;
      color:#fff;
      position:relative;
      z-index:10;
    }

    .logo img { width:150px; margin-bottom:20px; filter: drop-shadow(0 0 5px rgba(0,0,0,0.6)); }

    .form-group { position:relative; margin-bottom:20px; }
    .form-group i {
      position:absolute;
      top:12px; left:15px;
      color:#0a0a0a;
    }
    input[type="text"], input[type="password"] {
      width:100%;
      padding:12px 15px 12px 40px;
      border:none;
      border-radius:10px;
      background:rgba(255,255,255,0.1);
      color:#171616;
      font-size:15px;
      transition:0.3s;
    }
    input:focus {
      outline:none;
      background:rgba(255,255,255,0.2);
      box-shadow:0 0 8px #171616;
    }

    button {
      width:100%;
      padding:12px;
      background:linear-gradient(135deg, #ff6600, #ff3300);
      border:none;
      border-radius:10px;
      color:#fff;
      font-weight:600;
      font-size:16px;
      cursor:pointer;
      transition:0.3s;
      box-shadow:0 4px 15px rgba(255,100,0,0.4);
    }
    button:hover {
      transform:translateY(-2px) scale(1.02);
      box-shadow:0 6px 20px rgba(255,80,0,0.6);
    }

    .remember { text-align:left; margin-bottom:20px; font-size:14px; color:#ccc; }
    .remember input { margin-right:8px; }

    .error-msg {
      background:rgba(255,50,50,0.2);
      padding:10px; border-radius:8px;
      margin-bottom:20px; font-size:14px;
      color:#ffbaba;
      animation: shake 0.4s ease;
    }

    @keyframes fadeIn { from {opacity:0; transform:translateY(-20px);} to {opacity:1; transform:translateY(0);} }
    @keyframes shake {
      0% {transform:translateX(0);}
      25% {transform:translateX(-5px);}
      50% {transform:translateX(5px);}
      75% {transform:translateX(-5px);}
      100% {transform:translateX(0);}
    }

    @media(max-width:480px){
      .login-container { padding:30px 20px; }
      .logo img { width:120px; }
    }
  </style>
</head>
<body>

  <!-- partículas no fundo -->
  <div class="particle"></div>
  <div class="particle"></div>
  <div class="particle"></div>
  <div class="particle"></div>
  <div class="particle"></div>

  <div class="login-container">
    <div class="logo">
      <img src="img/LOGO-NOVA.png" alt="Logo">
    </div>

    <?php if ($msgErro): ?>
      <div class="error-msg"><?= $msgErro ?></div>
    <?php endif; ?>

    <form method="post">
      <div class="form-group">
        <i class="fas fa-user"></i>
        <input type="text" name="nome" placeholder="Usuário" required>
      </div>
      <div class="form-group">
        <i class="fas fa-lock"></i>
        <input type="password" name="senha" placeholder="Senha" required>
      </div>

      <div class="remember">
        <label><input type="checkbox" name="lembrar"> manter logado</label>
      </div>

      <button type="submit">entrar</button>
    </form>
  </div>
</body>
</html>
