<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'conexao.php'; // Inclua a conexão com o banco de dados

// Verifique se a variável $pdo foi definida corretamente
if (!isset($pdo)) {
    die("Erro: A conexão com o banco de dados não foi estabelecida.");
}

// Verifica se o parâmetro 'tipo' está presente na URL
if (isset($_GET['tipo'])) {
    $tipo = $_GET['tipo']; // Pode ser 'restaurante' ou 'motoboy'
    
    // Ajuste da consulta SQL de acordo com o tipo
    $sql = "SELECT id, nome, email, tipo, status FROM usuarios WHERE tipo = :tipo";
} else {
    $sql = "SELECT id, nome, email, tipo, status FROM usuarios";
}

try {
    // Prepara a consulta para prevenir injeção de SQL
    $stmt = $pdo->prepare($sql);
    
    // Se o tipo foi passado, adiciona o parâmetro
    if (isset($tipo)) {
        $stmt->bindParam(':tipo', $tipo, PDO::PARAM_STR);
    }

    // Executa a consulta no banco de dados
    $stmt->execute();

    // Checa se há usuários na tabela
    if ($stmt->rowCount() > 0) {
        // Cria um array para armazenar os dados dos usuários
        $usuarios = array();

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            // Adiciona cada usuário ao array
            $usuarios[] = $row;
        }

        // Retorna os dados como JSON
        echo json_encode($usuarios);
    } else {
        // Se não houver usuários, retorna um array vazio
        echo json_encode([]);
    }
} catch (PDOException $e) {
    // Caso ocorra algum erro na consulta
    echo "Erro na consulta: " . $e->getMessage();
}
?>
