<?php
require 'conexao.php';
require_once 'dompdf/autoload.inc.php';
use Dompdf\Dompdf;

session_start();

if (!isset($_SESSION['usuario']['id'])) {
    die("ID do restaurante não encontrado na sessão.");
}

$restaurante_id = $_SESSION['usuario']['id'];
$nome_usuario = $_SESSION['usuario']['nome'] ?? 'Usuário';

$data_inicio = $_POST['data_inicio'] ?? null;
$data_fim = $_POST['data_fim'] ?? null;

if (!$data_inicio || !$data_fim) {
    die("Datas de início e fim são obrigatórias.");
}

$sql = "
SELECT 
  e.destino, 
  bt.nome_bairro, 
  e.criado_em, 
  e.taxa, 
  u.nome AS nome_motoboy
FROM entregas e
LEFT JOIN usuarios u ON e.motoboy_id = u.id
LEFT JOIN bairros_taxas bt ON e.bairro_id = bt.id
WHERE e.restaurante_id = :restaurante_id
AND e.criado_em BETWEEN :data_inicio AND :data_fim
ORDER BY e.criado_em ASC
";

$stmt = $pdo->prepare($sql);
$stmt->execute([
    ':restaurante_id' => $restaurante_id,
    ':data_inicio' => $data_inicio . ' 00:00:00',
    ':data_fim' => $data_fim . ' 23:59:59'
]);

$entregas = $stmt->fetchAll(PDO::FETCH_ASSOC);

$html = '<h1>Relatório de Entregas</h1>';

// Aqui adiciona nome do usuário e período da pesquisa
$html .= '<p><strong>Usuário:</strong> ' . htmlspecialchars($nome_usuario) . '</p>';
$html .= '<p><strong>Período:</strong> ' . date('d/m/Y', strtotime($data_inicio)) . ' até ' . date('d/m/Y', strtotime($data_fim)) . '</p>';

$html .= '<table border="1" width="100%" cellspacing="0" cellpadding="5">';
$html .= '
  <tr>
    <th>Destino</th>
    <th>Bairro</th>
    <th>Motoboy</th>
    <th>Data</th>
    <th>Taxa (R$)</th>
  </tr>';

$totalTaxa = 0;
foreach ($entregas as $entrega) {
    $html .= '<tr>';
    $html .= '<td>' . htmlspecialchars($entrega['destino']) . '</td>';
    $html .= '<td>' . htmlspecialchars($entrega['nome_bairro'] ?? 'N/D') . '</td>';
    $html .= '<td>' . htmlspecialchars($entrega['nome_motoboy'] ?? 'Não Aceita') . '</td>';
    $html .= '<td>' . date('d/m/Y H:i', strtotime($entrega['criado_em'])) . '</td>';
    $html .= '<td style="text-align:right;">' . number_format($entrega['taxa'], 2, ',', '.') . '</td>';
    $html .= '</tr>';

    $totalTaxa += $entrega['taxa'];
}

$html .= '<tr>';
$html .= '<td colspan="4" style="text-align:right;"><strong>Total:</strong></td>';
$html .= '<td style="text-align:right;"><strong>' . number_format($totalTaxa, 2, ',', '.') . '</strong></td>';
$html .= '</tr>';
$html .= '</table>';

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("relatorio_entregas.pdf", ["Attachment" => false]);
exit;
?>
