<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);


// gerar_pdf_entregas.php
require_once 'dompdf/autoload.inc.php'; // Ajuste o caminho se usar manual

use Dompdf\Dompdf;

include 'autentica.php';
include 'conexao.php';


error_reporting(E_ALL);
ini_set('display_errors', 1);


if ($usuario['tipo'] != 'admin') {
    exit('Acesso negado');
}

// Recebe filtros da URL
$data_ini = $_GET['data_ini'] ?? '';
$data_fim = $_GET['data_fim'] ?? '';
$motoboy = $_GET['motoboy'] ?? '';

// Monta consulta din09mica com filtros
$sql = "SELECT e.*, u.nome as motoboy_nome FROM entregas e LEFT JOIN usuarios u ON e.motoboy_id = u.id WHERE 1=1 ";
$params = [];

if ($data_ini) {
    $sql .= " AND e.data_entrega >= :data_ini ";
    $params[':data_ini'] = $data_ini;
}
if ($data_fim) {
    $sql .= " AND e.data_entrega <= :data_fim ";
    $params[':data_fim'] = $data_fim;
}
if ($motoboy) {
    $sql .= " AND e.motoboy_id = :motoboy ";
    $params[':motoboy'] = $motoboy;
}

$sql .= " ORDER BY e.data_entrega DESC ";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$entregas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Monta o HTML para o PDF
$html = '<h1>Relatrio de Entregas</h1>';
$html .= '<p>Filtros: ';
$html .= $data_ini ? 'De: ' . htmlspecialchars($data_ini) . ' ' : '';
$html .= $data_fim ? 'At: ' . htmlspecialchars($data_fim) . ' ' : '';
if ($motoboy) {
    // Busca nome do motoboy
    $stmtM = $pdo->prepare("SELECT nome FROM usuarios WHERE id = ?");
    $stmtM->execute([$motoboy]);
    $nomeM = $stmtM->fetchColumn();
    $html .= 'Motoboy: ' . htmlspecialchars($nomeM);
}
$html .= '</p>';

$html .= '<table border="1" cellpadding="5" cellspacing="0" style="width:100%; border-collapse: collapse;">';
$html .= '<thead><tr>
    <th>ID</th>
    <th>Descri0400o</th>
    <th>Data Entrega</th>
    <th>Motoboy</th>
    <th>Status</th>
  </tr></thead><tbody>';

foreach ($entregas as $e) {
    $html .= '<tr>';
    $html .= '<td>' . htmlspecialchars($e['id']) . '</td>';
    $html .= '<td>' . htmlspecialchars($e['descricao']) . '</td>';
    $html .= '<td>' . htmlspecialchars($e['data_entrega']) . '</td>';
    $html .= '<td>' . htmlspecialchars($e['motoboy_nome'] ?? '-') . '</td>';
    $html .= '<td>' . htmlspecialchars($e['status']) . '</td>';
    $html .= '</tr>';
}

$html .= '</tbody></table>';

// Gera PDF
$dompdf = new Dompdf();
$dompdf->loadHtml($html);

// (Opcional) Definir tamanho do papel e orienta0400o
$dompdf->setPaper('A4', 'portrait');

$dompdf->render();

// Envia PDF para navegador
$dompdf->stream("relatorio_entregas.pdf", ["Attachment" => false]);
exit;
