<?php
include 'autentica.php';
include 'conexao.php';

if ($usuario['tipo'] != 'admin') {
    exit(json_encode(['status' => 'erro', 'mensagem' => 'Acesso negado']));
}

$id = $_POST['id'] ?? 0;
$id = (int) $id;

if (!$id) {
    exit(json_encode(['status' => 'erro', 'mensagem' => 'ID inválido']));
}

try {
    $pdo->beginTransaction();

    // Desvincula usuário como restaurante (define restaurante_id = NULL)
    $stmt1 = $pdo->prepare("UPDATE entregas SET restaurante_id = NULL WHERE restaurante_id = ?");
    $stmt1->execute([$id]);

    // Desvincula usuário como motoboy (define motoboy_id = NULL)
    $stmt2 = $pdo->prepare("UPDATE entregas SET motoboy_id = NULL WHERE motoboy_id = ?");
    $stmt2->execute([$id]);

    // Apaga o usuário
    $stmt3 = $pdo->prepare("DELETE FROM usuarios WHERE id = ?");
    $stmt3->execute([$id]);

    $pdo->commit();

    echo json_encode(['status' => 'ok', 'mensagem' => 'Usuário excluído e entregas desvinculadas com sucesso']);

} catch (PDOException $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo json_encode(['status' => 'erro', 'mensagem' => 'Erro no banco: ' . $e->getMessage()]);
}
