<?php
session_start();
include 'conexao.php'; // sua conexão com banco
include 'autentica.php';

if ($usuario['tipo'] != 'motoboy') exit('Acesso negado');

$id_usuario   = $usuario['id']; // assumindo que tem o id salvo na sessão
$nome         = trim($_POST['nome'] ?? '');
$email        = filter_var($_POST['email'], FILTER_VALIDATE_EMAIL);
$senha_atual  = $_POST['senha_atual'] ?? '';
$nova_senha   = $_POST['nova_senha'] ?? '';
$confirma_senha = $_POST['confirma_senha'] ?? '';

if (!$nome) {
  exit('O nome não pode estar vazio.');
}

if (!$email) {
  exit('Email inválido.');
}

// Buscar o usuário no banco
$sql = $pdo->prepare("SELECT senha FROM usuarios WHERE id = ?");
$sql->execute([$id_usuario]);
$usuario_db = $sql->fetch();

if (!$usuario_db) {
  exit('Usuário não encontrado.');
}

// Verificar senha atual (assumindo que senha está armazenada com password_hash)
if (!password_verify($senha_atual, $usuario_db['senha'])) {
  exit('Senha atual incorreta.');
}

if ($nova_senha) {
  if ($nova_senha !== $confirma_senha) {
    exit('A nova senha e a confirmação não coincidem.');
  }
  $senha_hash = password_hash($nova_senha, PASSWORD_DEFAULT);
} else {
  $senha_hash = $usuario_db['senha']; // mantém a senha atual
}

// Atualizar dados
$update = $pdo->prepare("UPDATE usuarios SET nome = ?, email = ?, senha = ? WHERE id = ?");
if ($update->execute([$nome, $email, $senha_hash, $id_usuario])) {
  echo 'Perfil atualizado com sucesso!';
} else {
  echo 'Erro ao atualizar o perfil.';
}
?>
