<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'].'/conexao.php';  // Certifique-se de que o caminho está correto

// Verifique se o usuário está autenticado
if (!isset($_SESSION['usuario'])) {
    die("Erro: Usuário não autenticado.");
}

// Obter o ID do usuário logado
$user_id = $_SESSION['usuario_id']; // A variável de sessão que contém o ID do usuário logado

$data = json_decode(file_get_contents("php://input"), true);  // Recebe os dados JSON enviados via POST

$mensagem = $data['mensagem'];   // Mensagem do usuário
$usuario_id_destino = $data['usuario_id_destino'];  // ID do usuário com quem o usuário deseja conversar
$usuario_id_logado = $data['usuario_id_logado'];  // ID do usuário logado (que está enviando a mensagem)

// Verificar se o ID do usuário destino foi fornecido
if (empty($usuario_id_destino)) {
    die("Erro: O ID do usuário destino não foi fornecido.");
}

try {
    // Criar a conversa se não existir
    $sql_conversa = "INSERT INTO conversas (id_usuario1, id_usuario2, ultimo_mensagem) 
                     VALUES (:usuario_id_logado, :usuario_id_destino, :mensagem)";
    $stmt_conversa = $pdo->prepare($sql_conversa);
    $stmt_conversa->bindParam(':usuario_id_logado', $usuario_id_logado, PDO::PARAM_INT);  // ID do usuário logado
    $stmt_conversa->bindParam(':usuario_id_destino', $usuario_id_destino, PDO::PARAM_INT);  // ID do destinatário
    $stmt_conversa->bindParam(':mensagem', $mensagem, PDO::PARAM_STR);
    $stmt_conversa->execute();

    // Obter o ID da nova conversa
    $conversa_id = $pdo->lastInsertId();

    // Enviar a primeira mensagem
    $sql_mensagem = "INSERT INTO mensagens (id_conversa, id_remetente, mensagem, data_envio) 
                     VALUES (:conversa_id, :usuario_id_logado, :mensagem, NOW())";
    $stmt_mensagem = $pdo->prepare($sql_mensagem);
    $stmt_mensagem->bindParam(':conversa_id', $conversa_id, PDO::PARAM_INT);
    $stmt_mensagem->bindParam(':usuario_id_logado', $usuario_id_logado, PDO::PARAM_INT);  // O ID do usuário logado será o remetente
    $stmt_mensagem->bindParam(':mensagem', $mensagem, PDO::PARAM_STR);
    $stmt_mensagem->execute();

    // Atualizar o campo de última mensagem na tabela de conversas
    $sql_update = "UPDATE conversas SET ultimo_mensagem = NOW() WHERE id = :conversa_id";
    $stmt_update = $pdo->prepare($sql_update);
    $stmt_update->bindParam(':conversa_id', $conversa_id, PDO::PARAM_INT);
    $stmt_update->execute();

    echo 'Conversa iniciada e mensagem enviada com sucesso!';
} catch (Exception $e) {
    // Captura de exceções e erro no servidor
    echo 'Erro: ' . $e->getMessage();
}

