<?php
session_start();
require 'conexao.php';

$restaurante_id = $_SESSION['usuario']['id'] ?? null;

if (!$restaurante_id) {
  echo "<p class='text-danger'>Restaurante não identificado.</p>";
  exit;
}


$sql = $pdo->prepare("SELECT e.*, b.nome_bairro, u.nome AS nome_motoboy 
                      FROM entregas e 
                      LEFT JOIN bairros_taxas b ON e.bairro_id = b.id
                      LEFT JOIN usuarios u ON e.motoboy_id = u.id
                      WHERE e.restaurante_id = :id 
                      ORDER BY e.criado_em DESC");




$sql->execute([':id' => $restaurante_id]);
$entregas = $sql->fetchAll();

if (!$entregas) {
  echo "<p class='text-muted'>Nenhuma entrega encontrada.</p>";
  exit;
}
?>

<table class="table table-bordered table-striped table-sm">
  <thead class="table-dark">
    <tr>
      <th>ID</th>
      <th>Destino</th>
      <th>Bairro</th>
      <th>Taxa</th>
     
      <th>Status</th>
      <th>Motoboy</th>
      <th>Criado em</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($entregas as $entrega): ?>
      <tr>
        <td><?= $entrega['id'] ?></td>
        <td><?= htmlspecialchars($entrega['destino']) ?></td>
        <td><?= htmlspecialchars($entrega['nome_bairro']) ?></td>
        <td>R$ <?= number_format($entrega['taxa'], 2, ',', '.') ?></td>
      
        <td><?= ucfirst($entrega['status']) ?></td>
        <td><?= $entrega['nome_motoboy'] ? htmlspecialchars($entrega['nome_motoboy']) : '<span class="text-muted">Aguardando...</span>' ?></td>
        <td><?= date('d/m/Y H:i', strtotime($entrega['criado_em'])) ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

