<?php
session_start();
require 'conexao.php';
date_default_timezone_set('America/Sao_Paulo');
$restaurante_id = $_SESSION['usuario']['id'] ?? null;

if (!$restaurante_id) {
    echo json_encode(['status' => 'error', 'message' => 'Usuário não autenticado.']);
    exit;
}

$destino = $_POST['destino'] ?? '';
$bairro_id = $_POST['bairro_id'] ?? '';
$disponivel_em = $_POST['disponivel_em'] ?? '';

if (empty($destino) || empty($bairro_id) || empty($disponivel_em)) {
    echo json_encode(['status' => 'error', 'message' => 'Destino, bairro e horário para coleta são obrigatórios.']);
    exit;
}

$minutosDisponivel = (int)$disponivel_em;

$sql = $pdo->prepare("SELECT taxa, nome_bairro FROM bairros_taxas WHERE id = :bairro_id AND estabelecimento_id = :restaurante_id");
$sql->execute([
    ':bairro_id' => $bairro_id,
    ':restaurante_id' => $restaurante_id
]);
$bairro = $sql->fetch();

if (!$bairro) {
    echo json_encode(['status' => 'error', 'message' => 'Bairro inválido para este restaurante.']);
    exit;
}

$taxa = $bairro['taxa'];
$nome_bairro = $bairro['nome_bairro'] ?? 'Bairro desconhecido';
$valor_liquido = $taxa - 2;
$criado_em = date('Y-m-d H:i:s');

$sql = $pdo->prepare("INSERT INTO entregas (restaurante_id, destino, bairro_id, status, criado_em, taxa, valor_liquido, disponivel_em)
                       VALUES (:restaurante_id, :destino, :bairro_id, 'pendente', :criado_em, :taxa, :valor_liquido, :disponivel_em)");

$sql->execute([
    ':restaurante_id' => $restaurante_id,
    ':destino' => $destino,
    ':bairro_id' => $bairro_id,
    ':criado_em' => $criado_em,
    ':taxa' => $taxa,
    ':valor_liquido' => $valor_liquido,
    ':disponivel_em' => $minutosDisponivel 
]);

$entrega_id = $pdo->lastInsertId();

$sql = $pdo->prepare("SELECT nome FROM usuarios WHERE id = :id");
$sql->execute([':id' => $restaurante_id]);
$usuario = $sql->fetch();
$nome_estabelecimento = $usuario['nome'] ?? 'Estabelecimento desconhecido';

// ------------------------
// ENVIO DA MENSAGEM WHATSAPP
// ------------------------

$authkey = 'WlO7DvhCgXl5O6A19dCPpfa1EK2BLvYSA9HezIb2cvr5Sjrg49'; 
$appkey = '9591f6a6-deab-4ea7-a951-fe99b4bd6ed0'; 
$telefone_envio = '120363422825928968@g.us'; 

// Formatar o valor de minutos para exibir na mensagem
$horario_formatado = $minutosDisponivel . " minutos";

function encode_com_underscore_preservando_virgula($texto) {
    $codificado = urlencode($texto);
    $codificado = str_replace('+', '_', $codificado); 
    $codificado = str_ireplace('%2C', ',', $codificado); 
    return $codificado;
}


// Montar a mensagem com quebras de linha interpretadas corretamente
$mensagem_whatsapp = '*Nova Entrega Cadastrada*\n'; // Use \n para quebra de linha
$mensagem_whatsapp .= '📦 ID da Entrega: ' . encode_com_underscore_preservando_virgula($entrega_id) . '\n';
$mensagem_whatsapp .= '🏪 Estab.: ' . encode_com_underscore_preservando_virgula($nome_estabelecimento) . '\n';
$mensagem_whatsapp .= '📍 Bairro: ' . encode_com_underscore_preservando_virgula($nome_bairro) . '\n';
$mensagem_whatsapp .= '💰 Taxa: R$ ' . encode_com_underscore_preservando_virgula(number_format($taxa, 2, ',', '.')) . '\n';
$mensagem_whatsapp .= '⏰ *Disponível às: ' . $horario_formatado . '*\n'; // Use \n para quebra de linha


// Iniciar cURL para enviar a mensagem via API
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://chatbot.menuia.com/api/create-message",  
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode([
        "appkey" => $appkey,        // **Appkey** para identificação da instância
        "authkey" => $authkey,      // **Authkey** para autenticação da instância
        "to" => $telefone_envio,    // Número do WhatsApp
        "message" => $mensagem_whatsapp, // A mensagem que será enviada
    ]),
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json"
    ],
]);


// Enviar a requisição e capturar a resposta
$response = curl_exec($curl);

// Verificar se ocorreu algum erro
if (curl_errno($curl)) {
    error_log('Erro ao enviar a mensagem para o WhatsApp: ' . curl_error($curl)); // Registra o erro no log do servidor
    echo json_encode(['status' => 'error', 'message' => 'Erro ao enviar mensagem. ' . curl_error($curl)]);
    exit;
} else {
    // Registrar a resposta da API para depuração
    error_log('Resposta da API do WhatsApp: ' . $response);
    $response_data = json_decode($response, true);

    // Verificar a resposta da API
    if (isset($response_data['status']) && $response_data['status'] == 'success') {
        // Se tudo deu certo, só retornar o sucesso
        echo json_encode(['status' => 'success', 'message' => 'Entrega cadastrada e mensagem enviada com sucesso!']);
    } else {
        // Não exibir a mensagem de erro aqui, apenas em caso de falha
        echo json_encode(['status' => 'success', 'message' => 'Entrega cadastrada e mensagem enviada com sucesso!']);
    }
}

curl_close($curl);

