<?php
session_start();
include 'conexao.php';

// Verifica se usuário está logado e é restaurante
if (!isset($_SESSION['usuario']) || $_SESSION['usuario']['tipo'] !== 'restaurante') {
    echo "<div class='alert alert-danger'>Restaurante não identificado. Faça login novamente.</div>";
    exit;
}

$restaurante_id = $_SESSION['usuario']['id'];

// Recebe dados do filtro via POST
$data_inicio = $_POST['data_inicio'] ?? '';
$data_fim = $_POST['data_fim'] ?? '';

// Validação simples
if (!$data_inicio || !$data_fim) {
    echo "<div class='alert alert-warning'>Por favor, informe as duas datas para filtrar.</div>";
    exit;
}

// Ajusta formato para datetime completo, incluindo horas para o filtro correto
$data_inicio .= " 00:00:00";
$data_fim .= " 23:59:59";

try {
    $sql = $pdo->prepare("
        SELECT e.*, u.nome AS nome_motoboy, b.nome_bairro 
        FROM entregas e
        LEFT JOIN usuarios u ON e.motoboy_id = u.id
        LEFT JOIN bairros_taxas b ON e.bairro_id = b.id
        WHERE e.restaurante_id = :restaurante_id 
          AND e.criado_em BETWEEN :data_inicio AND :data_fim
        ORDER BY e.criado_em DESC
    ");

    $sql->bindValue(':restaurante_id', $restaurante_id, PDO::PARAM_INT);
    $sql->bindValue(':data_inicio', $data_inicio);
    $sql->bindValue(':data_fim', $data_fim);
    $sql->execute();

    $entregas = $sql->fetchAll(PDO::FETCH_ASSOC);

    if (!$entregas) {
        echo "<div class='alert alert-info'>Nenhuma entrega encontrada para este período.</div>";
        exit;
    }

    // Monta a tabela com as entregas encontradas
    echo '<table class="table table-striped table-dark table-hover">';
    echo '<thead><tr>';
    echo '<th>ID</th>';
    echo '<th>Destino</th>';
    echo '<th>Bairro</th>';
    echo '<th>Status</th>';
    echo '<th>Motoboy</th>';
    echo '<th>Data da Criação</th>';
    echo '<th>Taxa</th>';
    echo '<th>Valor Líquido</th>';
    echo '</tr></thead><tbody>';

    foreach ($entregas as $e) {
        echo '<tr>';
        echo '<td>' . htmlspecialchars($e['id']) . '</td>';
        echo '<td>' . htmlspecialchars($e['destino']) . '</td>';
        echo '<td>' . htmlspecialchars($e['nome_bairro']) . '</td>';
        echo '<td>' . htmlspecialchars($e['status']) . '</td>';
        echo '<td>' . htmlspecialchars($e['nome_motoboy'] ?? 'Sem motoboy') . '</td>';
        echo '<td>' . htmlspecialchars($e['criado_em']) . '</td>';
        echo '<td>R$ ' . number_format($e['taxa'], 2, ',', '.') . '</td>';
        echo '<td>R$ ' . number_format($e['valor_liquido'], 2, ',', '.') . '</td>';
        echo '</tr>';
    }

    echo '</tbody></table>';
} catch (PDOException $ex) {
    echo "<div class='alert alert-danger'>Erro ao buscar entregas: " . $ex->getMessage() . "</div>";
}
?>
