<?php
session_start();
include 'conexao.php';

// Verifica se o usuário é admin
if (!isset($_SESSION['usuario']) || $_SESSION['usuario']['tipo'] !== 'admin') {
  http_response_code(403);
  echo json_encode(['sucesso' => false, 'mensagem' => 'Acesso negado']);
  exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id = $_POST['id'] ?? null;
  $status = $_POST['status'] ?? null;

  if (!$id || !in_array($status, ['ATIVO', 'INATIVO'])) {
    echo json_encode(['sucesso' => false, 'mensagem' => 'Dados inválidos']);
    exit;
  }

  $sql = $pdo->prepare("UPDATE usuarios SET status = ? WHERE id = ?");
  $sucesso = $sql->execute([$status, $id]);

  if ($sucesso) {
    echo json_encode(['sucesso' => true]);
  } else {
    echo json_encode(['sucesso' => false, 'mensagem' => 'Erro ao atualizar status']);
  }
} else {
  echo json_encode(['sucesso' => false, 'mensagem' => 'Método inválido']);
}
?>
