import Link from "next/link";
import AppLogo from "@/components/ui/AppLogo";
import Icon from "@/components/ui/AppIcon";

export default function Footer() {
  const currentYear = 2026;

  return (
    <footer className="bg-brand-dark border-t border-white/5">
      <div className="max-w-7xl mx-auto px-6 lg:px-8 py-16">
        {/* Main Row */}
        <div className="flex flex-col lg:flex-row items-start justify-between gap-12 mb-12">
          {/* Brand */}
          <div className="max-w-xs">
            <AppLogo
              size={64}
              text="ADVOPACK"
              iconName="CpuChipIcon"
              className="brightness-0 invert mb-4"
            />
            <p className="text-secondary text-sm leading-relaxed mt-2">
              Sistemas personalizados que transformam a operação do seu negócio.
              Tecnologia sob medida, do planejamento à entrega.
            </p>
            <div className="flex items-center gap-3 mt-6">
              <a
                href="https://linkedin.com"
                target="_blank"
                rel="noopener noreferrer"
                className="w-9 h-9 rounded-lg bg-white/8 border border-white/10 flex items-center justify-center text-secondary hover:text-white hover:bg-primary transition-all duration-200"
                aria-label="LinkedIn"
              >
                <Icon name="GlobeAltIcon" size={16} />
              </a>
              <a
                href="https://instagram.com"
                target="_blank"
                rel="noopener noreferrer"
                className="w-9 h-9 rounded-lg bg-white/8 border border-white/10 flex items-center justify-center text-secondary hover:text-white hover:bg-primary transition-all duration-200"
                aria-label="Instagram"
              >
                <Icon name="CameraIcon" size={16} />
              </a>
              <a
                href="https://wa.me/5511999999999"
                target="_blank"
                rel="noopener noreferrer"
                className="w-9 h-9 rounded-lg bg-white/8 border border-white/10 flex items-center justify-center text-secondary hover:text-white hover:bg-primary transition-all duration-200"
                aria-label="WhatsApp"
              >
                <Icon name="ChatBubbleOvalLeftEllipsisIcon" size={16} />
              </a>
            </div>
          </div>

          {/* Links */}
          <div className="flex flex-wrap gap-12">
            <div>
              <p className="text-white font-semibold font-heading text-sm mb-4 tracking-wide">
                Navegação
              </p>
              <ul className="space-y-2.5">
                {[
                  { label: "Início", href: "/homepage" },
                  { label: "Sistemas", href: "/systems" },
                  { label: "Sobre", href: "/homepage#sobre" },
                  { label: "Preços", href: "/homepage#precos" },
                ]?.map((link) => (
                  <li key={link?.href}>
                    <Link
                      href={link?.href}
                      className="text-secondary text-sm hover:text-white transition-colors duration-200"
                    >
                      {link?.label}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>

            <div>
              <p className="text-white font-semibold font-heading text-sm mb-4 tracking-wide">
                Soluções
              </p>
              <ul className="space-y-2.5">
                {[
                  "Gestão Financeira",
                  "Controle de Estoque",
                  "Gestão de RH",
                  "Automação de Processos",
                  "Integrações API",
                ]?.map((item) => (
                  <li key={item}>
                    <Link
                      href="/systems"
                      className="text-secondary text-sm hover:text-white transition-colors duration-200"
                    >
                      {item}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>

            <div>
              <p className="text-white font-semibold font-heading text-sm mb-4 tracking-wide">
                Contato
              </p>
              <ul className="space-y-3">
                <li className="flex items-center gap-2 text-secondary text-sm">
                  <Icon name="EnvelopeIcon" size={14} className="text-accent flex-shrink-0" />
                  contato@advopack.com.br
                </li>
                <li className="flex items-center gap-2 text-secondary text-sm">
                  <Icon name="PhoneIcon" size={14} className="text-accent flex-shrink-0" />
                  +55 (11) 9 9999-9999
                </li>
                <li className="flex items-center gap-2 text-secondary text-sm">
                  <Icon name="MapPinIcon" size={14} className="text-accent flex-shrink-0" />
                  São Paulo, SP — Brasil
                </li>
              </ul>
            </div>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="pt-8 border-t border-white/8 flex flex-col sm:flex-row items-center justify-between gap-4">
          <p className="text-secondary/60 text-xs">
            © {currentYear} ADVOPACK. Todos os direitos reservados.
          </p>
          <div className="flex items-center gap-6">
            <Link href="#" className="text-secondary/60 text-xs hover:text-white transition-colors">
              Privacidade
            </Link>
            <Link href="#" className="text-secondary/60 text-xs hover:text-white transition-colors">
              Termos de Uso
            </Link>
            <span className="flex items-center gap-1.5 text-secondary/60 text-xs">
              <span className="w-1.5 h-1.5 rounded-full bg-green-400 animate-pulse" />
              Sistemas Online
            </span>
          </div>
        </div>
      </div>
    </footer>
  );
}