import type { Metadata } from "next";
import Header from "@/components/Header";
import Footer from "@/components/Footer";
import SystemsPageHeader from "./components/SystemsPageHeader";
import SystemsGrid from "./components/SystemsGrid";
import SystemsCtaSection from "./components/SystemsCtaSection";

export const metadata: Metadata = {
  title: "Sistemas — ADVOPACK | Catálogo de Soluções",
  description:
    "Explore o catálogo de sistemas desenvolvidos pela ADVOPACK. ERP, Gestão de RH, Hub de Marketplace, CRM, Financeiro e muito mais. Veja demos ao vivo.",
  keywords: [
    "sistemas personalizados",
    "ERP sob medida",
    "gestão de RH",
    "CRM personalizado",
    "hub marketplace",
    "gestão financeira",
    "ADVOPACK sistemas",
  ],
  openGraph: {
    title: "Catálogo de Sistemas — ADVOPACK",
    description: "Sistemas desenvolvidos sob medida para transformar a operação da sua empresa. Veja demos ao vivo.",
    type: "website",
  },
};

export default function SystemsPage() {
  return (
    <main className="min-h-screen bg-brand-bg">
      <Header />
      <SystemsPageHeader />
      <section className="py-16">
        <div className="max-w-7xl mx-auto px-6 lg:px-8">
          <SystemsGrid />
        </div>
      </section>
      <SystemsCtaSection />
      <Footer />
    </main>
  );
}