"use client";

import { useEffect } from "react";
import Link from "next/link";
import Icon from "@/components/ui/AppIcon";

export default function SystemsPageHeader() {
  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) entry.target.classList.add("visible");
        });
      },
      { threshold: 0.1 }
    );
    document.querySelectorAll(".reveal").forEach((el) => observer.observe(el));
    return () => observer.disconnect();
  }, []);

  return (
    <section className="relative pt-32 pb-20 overflow-hidden">
      {/* Background */}
      <div className="absolute inset-0 bg-gradient-to-br from-primary-dark via-primary to-accent" />
      <div className="absolute inset-0 grid-pattern opacity-25" />
      <div className="absolute top-0 right-0 w-[500px] h-[500px] rounded-full bg-white/5 blur-3xl pointer-events-none" />
      <div className="absolute bottom-0 left-0 w-80 h-80 rounded-full bg-accent/20 blur-3xl pointer-events-none" />

      {/* Decorative floating elements */}
      <div className="absolute top-24 right-12 hidden xl:block">
        <div className="glass-card-dark rounded-2xl p-4 w-48 animate-float-card shadow-elevated">
          <div className="flex items-center gap-2 mb-2">
            <div className="w-7 h-7 rounded-lg bg-white/15 flex items-center justify-center">
              <Icon name="CpuChipIcon" size={14} className="text-white" />
            </div>
            <p className="text-white font-heading font-bold text-xs">6 Sistemas</p>
          </div>
          <p className="text-white/50 text-[10px]">disponíveis para demo</p>
          <div className="flex gap-1 mt-2">
            {["ERP", "RH", "CRM"].map((t) => (
              <span key={t} className="text-[9px] font-bold bg-white/10 text-white/70 rounded px-1.5 py-0.5">
                {t}
              </span>
            ))}
          </div>
        </div>
      </div>

      <div className="max-w-7xl mx-auto px-6 lg:px-8 relative z-10">
        {/* Breadcrumb */}
        <div className="flex items-center gap-2 text-white/50 text-sm mb-8 reveal">
          <Link href="/homepage" className="hover:text-white transition-colors">
            Início
          </Link>
          <Icon name="ChevronRightIcon" size={14} />
          <span className="text-white font-medium">Sistemas</span>
        </div>

        <div className="max-w-3xl">
          <span className="inline-flex items-center gap-2 bg-white/10 border border-white/20 text-white/80 rounded-full px-4 py-2 text-xs font-bold tracking-widest uppercase mb-6 reveal">
            <Icon name="RectangleGroupIcon" size={12} />
            Catálogo de Soluções
          </span>

          <h1 className="font-heading font-extrabold text-5xl lg:text-6xl text-white leading-tight mb-6 reveal delay-100">
            Sistemas desenvolvidos
            <br />
            <span className="text-white/70">para o mundo real</span>
          </h1>

          <p className="text-white/70 text-lg leading-relaxed max-w-xl mb-8 reveal delay-200">
            Cada sistema desta vitrine foi construído do zero para atender as necessidades
            específicas de um cliente real. Explore, veja a demo ao vivo e imagine como
            podemos criar algo assim para a sua empresa.
          </p>

          <div className="flex flex-wrap gap-4 reveal delay-300">
            <a
              href="https://wa.me/5511999999999?text=Olá! Gostaria de saber mais sobre os sistemas ADVOPACK."
              target="_blank"
              rel="noopener noreferrer"
              className="btn-ghost text-sm"
            >
              <Icon name="ChatBubbleOvalLeftEllipsisIcon" size={16} />
              Solicitar Sistema Similar
            </a>
            <Link href="/homepage#como-trabalhamos" className="btn-ghost text-sm">
              <Icon name="MapIcon" size={16} />
              Como Trabalhamos
            </Link>
          </div>
        </div>

        {/* Stats bar */}
        <div className="grid grid-cols-2 md:grid-cols-4 gap-4 mt-14 reveal delay-400">
          {[
            { icon: "ComputerDesktopIcon", value: "6+", label: "Sistemas no catálogo" },
            { icon: "PlayIcon", value: "100%", label: "Com demo ao vivo" },
            { icon: "WrenchScrewdriverIcon", value: "48+", label: "Projetos entregues" },
            { icon: "StarIcon", value: "5/5", label: "Satisfação dos clientes" },
          ].map((stat) => (
            <div key={stat.label} className="bg-white/8 border border-white/12 rounded-2xl p-4 flex items-center gap-3">
              <div className="w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center flex-shrink-0">
                <Icon name={stat.icon as any} size={18} className="text-white/80" />
              </div>
              <div>
                <p className="font-heading font-extrabold text-xl text-white">{stat.value}</p>
                <p className="text-white/50 text-xs">{stat.label}</p>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}