"use client";

import { useEffect } from "react";
import Link from "next/link";
import Icon from "@/components/ui/AppIcon";

export default function SystemsCtaSection() {
  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) entry.target.classList.add("visible");
        });
      },
      { threshold: 0.2 }
    );
    document.querySelectorAll(".reveal").forEach((el) => observer.observe(el));
    return () => observer.disconnect();
  }, []);

  return (
    <section className="py-20 bg-white border-t border-gray-100">
      <div className="max-w-4xl mx-auto px-6 lg:px-8 text-center">
        <div className="bg-gradient-to-br from-primary-50 via-white to-blue-50 border border-primary/10 rounded-3xl p-12 reveal">
          <div className="w-16 h-16 rounded-2xl bg-gradient-primary flex items-center justify-center mx-auto mb-6 shadow-glow">
            <Icon name="LightBulbIcon" size={30} className="text-white" />
          </div>

          <h2 className="font-heading font-extrabold text-3xl lg:text-4xl text-primary-dark mb-4 reveal delay-100">
            Não encontrou o que precisa?
          </h2>
          <p className="text-gray-500 text-lg leading-relaxed max-w-xl mx-auto mb-8 reveal delay-200">
            Cada sistema que desenvolvemos começa como uma ideia única. Descreva sua necessidade e
            construímos do zero, exatamente como a sua operação exige.
          </p>

          <div className="flex flex-col sm:flex-row gap-4 justify-center reveal delay-300">
            <a
              href="https://wa.me/5511999999999?text=Olá! Preciso de um sistema personalizado para minha empresa."
              target="_blank"
              rel="noopener noreferrer"
              className="btn-primary text-base px-10 py-4"
            >
              <Icon name="ChatBubbleOvalLeftEllipsisIcon" size={18} />
              Descrever Minha Necessidade
            </a>
            <Link href="/homepage#precos" className="btn-secondary text-base px-10 py-4">
              <Icon name="CurrencyDollarIcon" size={18} />
              Ver Modelos de Contratação
            </Link>
          </div>

          <div className="flex flex-wrap justify-center gap-6 mt-8 reveal delay-400">
            {[
              { icon: "ClockIcon", text: "Discovery gratuito" },
              { icon: "DocumentCheckIcon", text: "Proposta em 48h" },
              { icon: "ShieldCheckIcon", text: "Contrato transparente" },
            ].map((item) => (
              <div key={item.text} className="flex items-center gap-2 text-sm text-gray-500">
                <Icon name={item.icon as any} size={15} className="text-accent" />
                {item.text}
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
}