"use client";

import { useEffect } from "react";
import Link from "next/link";
import Icon from "@/components/ui/AppIcon";

const plans = [
  {
    name: "Projeto Sob Medida",
    icon: "WrenchScrewdriverIcon",
    tagline: "Para empresas que precisam de um sistema completo",
    description:
      "Desenvolvemos do zero, com todos os módulos que sua operação exige. Orçamento definido após análise de escopo.",
    features: [
      "Levantamento completo de requisitos",
      "Arquitetura personalizada",
      "Módulos ilimitados",
      "Interface customizada",
      "Treinamento da equipe",
      "Documentação completa",
    ],
    cta: "Solicitar Proposta",
    featured: false,
  },
  {
    name: "Integração Específica",
    icon: "ArrowsRightLeftIcon",
    tagline: "Para quem já tem sistema e precisa de conexões",
    description:
      "Conectamos seu sistema atual a APIs externas, ERPs, gateways de pagamento, emissão de notas e qualquer serviço necessário.",
    features: [
      "Mapeamento de integrações",
      "Desenvolvimento de conectores",
      "Testes e validação",
      "Documentação técnica",
      "Suporte pós-implantação",
      "SLA garantido",
    ],
    cta: "Solicitar Proposta",
    featured: true,
  },
  {
    name: "Licença + Suporte",
    icon: "ShieldCheckIcon",
    tagline: "Para sistemas já desenvolvidos pela ADVOPACK",
    description:
      "Contrato de licença de uso com suporte técnico contínuo, manutenções corretivas, atualizações e evolução do sistema.",
    features: [
      "Suporte técnico dedicado",
      "Manutenções corretivas",
      "Atualizações de segurança",
      "Monitoramento 24/7",
      "Backup automático",
      "Evolução contínua",
    ],
    cta: "Solicitar Proposta",
    featured: false,
  },
];

export default function PricingSection() {
  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) entry.target.classList.add("visible");
        });
      },
      { threshold: 0.1 }
    );
    document.querySelectorAll(".reveal, .reveal-scale").forEach((el) => observer.observe(el));
    return () => observer.disconnect();
  }, []);

  return (
    <section className="py-24 bg-white" id="precos">
      <div className="max-w-7xl mx-auto px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-6">
          <span className="section-label mb-4 reveal">
            <Icon name="CurrencyDollarIcon" size={12} />
            Modelos de Contratação
          </span>
          <h2 className="font-heading font-extrabold text-4xl lg:text-5xl text-primary-dark mt-4 mb-5 reveal delay-100">
            Sem sistema engessado.
            <br />
            <span className="gradient-text">Orçamento sob medida.</span>
          </h2>
          <p className="text-gray-500 max-w-xl mx-auto leading-relaxed reveal delay-200">
            Cada projeto é único. O investimento é definido após entendermos o escopo real da sua
            demanda — sem valores genéricos ou surpresas no final.
          </p>
        </div>

        {/* Info banner */}
        <div className="bg-primary-50 border border-primary/10 rounded-2xl p-5 flex items-start gap-4 max-w-2xl mx-auto mb-14 reveal delay-300">
          <div className="w-10 h-10 rounded-xl bg-primary flex items-center justify-center flex-shrink-0">
            <Icon name="InformationCircleIcon" size={20} className="text-white" />
          </div>
          <div>
            <p className="font-heading font-semibold text-primary-dark text-sm mb-1">
              Como funciona o orçamento?
            </p>
            <p className="text-sm text-gray-500 leading-relaxed">
              Após uma reunião de descoberta gratuita, montamos uma proposta detalhada com escopo,
              prazo e investimento. Você decide sem compromisso.
            </p>
          </div>
        </div>

        {/* Pricing Cards */}
        <div className="grid lg:grid-cols-3 gap-8 mb-14">
          {plans.map((plan, i) => (
            <div
              key={plan.name}
              className={`pricing-card reveal delay-${(i + 1) * 100} ${plan.featured ? "featured" : ""}`}
            >
              {plan.featured && (
                <div className="absolute -top-3 left-1/2 -translate-x-1/2">
                  <span className="bg-white text-primary font-heading font-bold text-xs px-4 py-1.5 rounded-full shadow-card">
                    ✦ Mais Solicitado
                  </span>
                </div>
              )}

              <div className={`w-14 h-14 rounded-2xl flex items-center justify-center mb-6 ${plan.featured ? "bg-white/20" : "bg-primary-50"}`}>
                <Icon
                  name={plan.icon as any}
                  size={26}
                  className={plan.featured ? "text-white" : "text-primary"}
                />
              </div>

              <h3 className={`font-heading font-bold text-xl mb-1 ${plan.featured ? "text-white" : "text-primary-dark"}`}>
                {plan.name}
              </h3>
              <p className={`text-xs font-semibold mb-3 ${plan.featured ? "text-white/70" : "text-accent"}`}>
                {plan.tagline}
              </p>
              <p className={`text-sm leading-relaxed mb-6 ${plan.featured ? "text-white/80" : "text-gray-500"}`}>
                {plan.description}
              </p>

              <ul className="space-y-2.5 mb-8">
                {plan.features.map((feature) => (
                  <li key={feature} className="flex items-center gap-2.5">
                    <div className={`w-5 h-5 rounded-full flex items-center justify-center flex-shrink-0 ${plan.featured ? "bg-white/20" : "bg-green-50"}`}>
                      <Icon name="CheckIcon" size={11} className={plan.featured ? "text-white" : "text-green-600"} />
                    </div>
                    <span className={`text-sm ${plan.featured ? "text-white/90" : "text-gray-600"}`}>
                      {feature}
                    </span>
                  </li>
                ))}
              </ul>

              <Link
                href="/homepage#contato"
                className={`w-full text-center py-3.5 rounded-xl font-heading font-bold text-sm transition-all duration-300 block ${
                  plan.featured
                    ? "bg-white text-primary hover:bg-gray-50" :"bg-primary text-white hover:bg-primary-light"
                }`}
              >
                {plan.cta}
              </Link>
            </div>
          ))}
        </div>

        {/* Main CTA */}
        <div className="text-center reveal">
          <Link href="/homepage#contato" className="btn-primary text-base px-12 py-5 text-lg">
            <Icon name="ChatBubbleLeftRightIcon" size={20} />
            Solicitar Proposta Personalizada
          </Link>
          <p className="text-sm text-gray-400 mt-3">Reunião de discovery gratuita · Sem compromisso</p>
        </div>
      </div>
    </section>
  );
}