"use client";

import { useEffect } from "react";
import Icon from "@/components/ui/AppIcon";

const steps = [
  {
    number: "01",
    icon: "MagnifyingGlassIcon",
    title: "Levantamento de Requisitos",
    description:
      "Realizamos reuniões de discovery para entender profundamente sua operação, processos, dores e objetivos. Nenhum detalhe passa despercebido.",
    duration: "1-2 semanas",
  },
  {
    number: "02",
    icon: "PencilSquareIcon",
    title: "Arquitetura & Prototipagem",
    description:
      "Desenhamos a arquitetura do sistema, criamos protótipos interativos e validamos cada fluxo com a sua equipe antes de iniciar o desenvolvimento.",
    duration: "1-2 semanas",
  },
  {
    number: "03",
    icon: "CodeBracketIcon",
    title: "Desenvolvimento Ágil",
    description:
      "Desenvolvemos em sprints com entregas parciais. Você acompanha o progresso em tempo real e pode solicitar ajustes durante o processo.",
    duration: "4-12 semanas",
  },
  {
    number: "04",
    icon: "BeakerIcon",
    title: "Testes & Homologação",
    description:
      "Bateria completa de testes funcionais, de performance e segurança. Homologação com sua equipe para validar cada funcionalidade.",
    duration: "1-2 semanas",
  },
  {
    number: "05",
    icon: "RocketLaunchIcon",
    title: "Deploy & Treinamento",
    description:
      "Implantação em produção com migração de dados, treinamento da equipe e documentação completa entregue.",
    duration: "1 semana",
  },
  {
    number: "06",
    icon: "WrenchScrewdriverIcon",
    title: "Suporte Contínuo",
    description:
      "Após o go-live, mantemos suporte técnico dedicado, monitoramento proativo e evolução contínua do sistema conforme sua empresa cresce.",
    duration: "Contínuo",
  },
];

export default function HowWeWorkSection() {
  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) entry.target.classList.add("visible");
        });
      },
      { threshold: 0.1 }
    );
    document.querySelectorAll(".reveal, .reveal-scale, .reveal-left, .reveal-right").forEach((el) =>
      observer.observe(el)
    );
    return () => observer.disconnect();
  }, []);

  return (
    <section className="py-24 bg-brand-bg" id="como-trabalhamos">
      <div className="max-w-7xl mx-auto px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-16">
          <span className="section-label mb-4 reveal">
            <Icon name="MapIcon" size={12} />
            Nosso Processo
          </span>
          <h2 className="font-heading font-extrabold text-4xl lg:text-5xl text-primary-dark mt-4 mb-5 reveal delay-100">
            Como trabalhamos
            <span className="gradient-text"> do início ao fim</span>
          </h2>
          <p className="text-gray-500 max-w-xl mx-auto leading-relaxed reveal delay-200">
            Um processo estruturado que garante entregas dentro do prazo, dentro do orçamento
            e alinhadas com o que você realmente precisa.
          </p>
        </div>

        {/* Steps Grid */}
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
          {steps.map((step, i) => (
            <div
              key={step.number}
              className={`bg-white rounded-2xl p-7 border border-gray-100 hover:border-primary/20 hover:shadow-card transition-all duration-400 group relative overflow-hidden reveal delay-${Math.min((i + 1) * 100, 600)}`}
            >
              {/* Step number watermark */}
              <span className="absolute -top-2 -right-2 font-heading font-extrabold text-7xl text-primary/4 select-none leading-none">
                {step.number}
              </span>

              <div className="flex items-center gap-3 mb-4">
                <div className="step-number text-sm">{step.number}</div>
                <div className="w-10 h-10 rounded-xl bg-primary-50 flex items-center justify-center group-hover:bg-primary/10 transition-colors">
                  <Icon name={step.icon as any} size={20} className="text-primary" />
                </div>
              </div>

              <h3 className="font-heading font-bold text-base text-primary-dark mb-2">
                {step.title}
              </h3>
              <p className="text-sm text-gray-500 leading-relaxed mb-4">{step.description}</p>

              <div className="flex items-center gap-2">
                <Icon name="ClockIcon" size={12} className="text-accent" />
                <span className="text-xs font-semibold text-accent">{step.duration}</span>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}