"use client";

import { useEffect } from "react";
import Link from "next/link";
import Icon from "@/components/ui/AppIcon";

const stats = [
  { value: "48+", label: "Projetos entregues" },
  { value: "100%", label: "Personalizados" },
  { value: "99.9%", label: "Uptime médio" },
  { value: "24h", label: "Tempo de resposta" },
];

export default function CtaBannerSection() {
  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) entry.target.classList.add("visible");
        });
      },
      { threshold: 0.2 }
    );
    document.querySelectorAll(".reveal, .reveal-scale")?.forEach((el) => observer?.observe(el));
    return () => observer?.disconnect();
  }, []);

  return (
    <section className="py-24 relative overflow-hidden" id="contato">
      {/* Background */}
      <div className="absolute inset-0 bg-gradient-to-br from-primary-dark via-primary to-accent" />
      <div className="absolute inset-0 grid-pattern opacity-20" />
      <div className="absolute top-0 right-0 w-96 h-96 rounded-full bg-white/5 blur-3xl" />
      <div className="absolute bottom-0 left-0 w-80 h-80 rounded-full bg-white/5 blur-3xl" />
      <div className="max-w-7xl mx-auto px-6 lg:px-8 relative z-10">
        {/* Stats */}
        <div className="grid grid-cols-2 lg:grid-cols-4 gap-4 mb-16 reveal">
          {stats?.map((stat) => (
            <div key={stat?.label} className="stat-card">
              <p className="font-heading font-extrabold text-3xl lg:text-4xl text-white mb-1">
                {stat?.value}
              </p>
              <p className="text-white/60 text-sm">{stat?.label}</p>
            </div>
          ))}
        </div>

        {/* Main CTA */}
        <div className="text-center max-w-3xl mx-auto">
          <span className="inline-flex items-center gap-2 bg-white/10 border border-white/20 text-white/80 rounded-full px-4 py-2 text-xs font-bold tracking-widest uppercase mb-8 reveal">
            <span className="w-2 h-2 rounded-full bg-green-400 animate-pulse" />
            Vagas abertas para novos projetos
          </span>

          <h2 className="font-heading font-extrabold text-4xl lg:text-6xl text-white leading-tight mb-6 reveal delay-100">
            Pronto para ter o sistema
            <br />
            <span className="text-white/70">que sua empresa merece?</span>
          </h2>

          <p className="text-white/70 text-lg leading-relaxed mb-10 reveal delay-200">
            Agende uma reunião de discovery gratuita. Em 45 minutos, entendemos sua operação
            e apresentamos como podemos transformá-la com tecnologia sob medida.
          </p>

          <div className="flex flex-col sm:flex-row gap-4 justify-center reveal delay-300">
            <a
              href="https://wa.me/5511999999999?text=Olá! Gostaria de agendar uma demonstração dos sistemas ADVOPACK."
              target="_blank"
              rel="noopener noreferrer"
              className="btn-ghost text-base px-10 py-4"
            >
              <Icon name="ChatBubbleOvalLeftEllipsisIcon" size={20} />
              Falar no WhatsApp
            </a>
            <Link href="/systems" className="btn-ghost text-base px-10 py-4">
              <Icon name="EyeIcon" size={20} />
              Ver Sistemas
            </Link>
          </div>

          {/* Contact info */}
          <div className="flex flex-wrap justify-center gap-8 mt-12 reveal delay-400">
            <a
              href="mailto:contato@advopack.com.br"
              className="flex items-center gap-2 text-white/60 hover:text-white transition-colors text-sm"
            >
              <Icon name="EnvelopeIcon" size={16} />
              contato@advopack.com.br
            </a>
            <a
              href="tel:+5511999999999"
              className="flex items-center gap-2 text-white/60 hover:text-white transition-colors text-sm"
            >
              <Icon name="PhoneIcon" size={16} />
              +55 (11) 9 9999-9999
            </a>
            <span className="flex items-center gap-2 text-white/60 text-sm">
              <Icon name="MapPinIcon" size={16} />
              São Paulo, SP
            </span>
          </div>
        </div>
      </div>
    </section>
  );
}