"use client";

import { useEffect } from "react";
import Icon from "@/components/ui/AppIcon";

const capabilities = [
  {
    icon: "WrenchScrewdriverIcon",
    title: "Desenvolvimento Sob Medida",
    description:
      "Cada sistema é arquitetado do zero, seguindo os processos reais da sua empresa. Sem templates, sem limitações.",
    highlights: ["Análise de demanda", "Prototipagem rápida", "Código proprietário"],
    color: "from-blue-500 to-primary",
    bgColor: "bg-blue-50",
    iconColor: "text-blue-600",
  },
  {
    icon: "ArrowsRightLeftIcon",
    title: "Integração com APIs",
    description:
      "Conectamos seu sistema a qualquer serviço externo: ERPs, CRMs, gateways de pagamento, NFe, marketplaces e muito mais.",
    highlights: ["PIX & pagamentos", "NF-e / NFS-e", "Marketplaces"],
    color: "from-purple-500 to-accent",
    bgColor: "bg-purple-50",
    iconColor: "text-purple-600",
  },
  {
    icon: "CogIcon",
    title: "Automação de Processos",
    description:
      "Elimine tarefas manuais e repetitivas. Nossos sistemas executam fluxos completos automaticamente, 24 horas por dia.",
    highlights: ["Fluxos automáticos", "Notificações inteligentes", "Agendamentos"],
    color: "from-green-500 to-teal-500",
    bgColor: "bg-green-50",
    iconColor: "text-green-600",
  },
  {
    icon: "ArrowTrendingUpIcon",
    title: "Escalabilidade Total",
    description:
      "Sua empresa cresce, seu sistema acompanha. Arquitetura preparada para alta demanda e expansão contínua.",
    highlights: ["Alta disponibilidade", "Backup automático", "Performance garantida"],
    color: "from-orange-500 to-red-500",
    bgColor: "bg-orange-50",
    iconColor: "text-orange-600",
  },
];

export default function CapabilitiesSection() {
  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) entry.target.classList.add("visible");
        });
      },
      { threshold: 0.15 }
    );
    document.querySelectorAll(".reveal, .reveal-scale").forEach((el) => observer.observe(el));
    return () => observer.disconnect();
  }, []);

  return (
    <section className="py-24 bg-white" id="sobre">
      <div className="max-w-7xl mx-auto px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-16">
          <span className="section-label mb-4 reveal">
            <Icon name="SparklesIcon" size={12} />
            Nossas Capacidades
          </span>
          <h2 className="font-heading font-extrabold text-4xl lg:text-5xl text-primary-dark mt-4 mb-5 reveal delay-100">
            Tecnologia que trabalha
            <span className="gradient-text"> pelo seu negócio</span>
          </h2>
          <p className="text-lg text-gray-500 max-w-2xl mx-auto leading-relaxed reveal delay-200">
            Combinamos expertise técnica com profundo entendimento do seu mercado para entregar
            sistemas que realmente fazem diferença no dia a dia da operação.
          </p>
        </div>

        {/* Grid */}
        <div className="grid md:grid-cols-2 gap-8">
          {capabilities.map((cap, i) => (
            <div
              key={cap.title}
              className={`feature-card reveal delay-${(i + 1) * 100}`}
            >
              <div className="flex items-start gap-5">
                <div className={`icon-box ${cap.bgColor}`} style={{ color: "inherit" }}>
                  <Icon name={cap.icon as any} size={26} className={cap.iconColor} />
                </div>
                <div className="flex-1">
                  <h3 className="font-heading font-bold text-xl text-primary-dark mb-2">
                    {cap.title}
                  </h3>
                  <p className="text-gray-500 text-sm leading-relaxed mb-4">
                    {cap.description}
                  </p>
                  <div className="flex flex-wrap gap-2">
                    {cap.highlights.map((h) => (
                      <span
                        key={h}
                        className="inline-flex items-center gap-1.5 text-xs font-semibold text-primary bg-primary-50 rounded-full px-3 py-1"
                      >
                        <Icon name="CheckIcon" size={10} className="text-accent" />
                        {h}
                      </span>
                    ))}
                  </div>
                </div>
              </div>

              {/* Bottom gradient bar */}
              <div className={`mt-6 h-0.5 rounded-full bg-gradient-to-r ${cap.color} opacity-30`} />
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}