/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    './src/pages/**/*.{js,ts,jsx,tsx,mdx}',
    './src/components/**/*.{js,ts,jsx,tsx,mdx}',
    './src/app/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    extend: {
      colors: {
        primary: {
          DEFAULT: '#011363',
          light: '#0A1F8F',
          dark: '#010D45',
          50: '#EEF0FA',
          100: '#D5D9F3',
          200: '#ABB3E7',
          300: '#8190DB',
          400: '#576DCF',
          500: '#2D4AC3',
          600: '#0A1F8F',
          700: '#011363',
          800: '#010D45',
          900: '#000727',
        },
        secondary: {
          DEFAULT: '#9ea3ba',
          light: '#c4c8d8',
          dark: '#7a7f96',
        },
        accent: '#2563EB',
        'bg-main': '#F8F9FF',
        'bg-alt': '#EEF0FA',
        surface: '#FFFFFF',
        'text-main': '#0D1340',
        'text-muted': '#6B7280',
        border: '#E2E5F0',
      },
      fontFamily: {
        heading: ['"Plus Jakarta Sans"', 'sans-serif'],
        body: ['"DM Sans"', 'sans-serif'],
      },
      borderRadius: {
        card: '1.25rem',
        '2xl': '1rem',
        '3xl': '1.5rem',
        '4xl': '2rem',
      },
      boxShadow: {
        card: '0 4px 24px rgba(1, 19, 99, 0.08)',
        'card-hover': '0 12px 40px rgba(1, 19, 99, 0.16)',
        glow: '0 0 40px rgba(1, 19, 99, 0.25)',
        modal: '0 32px 80px rgba(1, 19, 99, 0.35)',
      },
      backgroundImage: {
        'hero-gradient': 'linear-gradient(135deg, #F8F9FF 0%, #EEF0FA 40%, #E0E4F5 100%)',
        'primary-gradient': 'linear-gradient(135deg, #011363 0%, #0A1F8F 100%)',
        'accent-gradient': 'linear-gradient(135deg, #011363 0%, #2563EB 100%)',
        'card-gradient': 'linear-gradient(135deg, #F8F9FF 0%, #EEF0FA 100%)',
      },
      animation: {
        'float': 'float 5s ease-in-out infinite',
        'float-delayed': 'float-delayed 7s ease-in-out 1s infinite',
        'pulse-glow': 'pulse-glow 3s ease-in-out infinite',
        'scroll-logo': 'scroll-logo 28s linear infinite',
        'fade-in-up': 'fade-in-up 0.6s cubic-bezier(0.25, 1, 0.5, 1) both',
        'scale-in': 'scale-in 0.4s cubic-bezier(0.25, 1, 0.5, 1) both',
        'spin-slow': 'spin-slow 20s linear infinite',
        'gradient-shift': 'gradient-shift 4s ease infinite',
      },
      keyframes: {
        float: {
          '0%, 100%': { transform: 'translateY(0px)' },
          '50%': { transform: 'translateY(-12px)' },
        },
        'float-delayed': {
          '0%, 100%': { transform: 'translateY(0px)' },
          '50%': { transform: 'translateY(-8px)' },
        },
        'pulse-glow': {
          '0%, 100%': { boxShadow: '0 0 20px rgba(1, 19, 99, 0.15)' },
          '50%': { boxShadow: '0 0 40px rgba(1, 19, 99, 0.3)' },
        },
        'scroll-logo': {
          '0%': { transform: 'translateX(0)' },
          '100%': { transform: 'translateX(-50%)' },
        },
        'fade-in-up': {
          from: { opacity: '0', transform: 'translateY(24px)' },
          to: { opacity: '1', transform: 'translateY(0)' },
        },
        'scale-in': {
          from: { opacity: '0', transform: 'scale(0.92)' },
          to: { opacity: '1', transform: 'scale(1)' },
        },
        'spin-slow': {
          from: { transform: 'rotate(0deg)' },
          to: { transform: 'rotate(360deg)' },
        },
        'gradient-shift': {
          '0%, 100%': { backgroundPosition: '0% 50%' },
          '50%': { backgroundPosition: '100% 50%' },
        },
      },
      transitionTimingFunction: {
        smooth: 'cubic-bezier(0.25, 1, 0.5, 1)',
      },
    },
  },
  plugins: [],
};