import type { Metadata } from "next";
import Header from "@/components/Header";
import Footer from "@/components/Footer";
import PricingInteractive from "./components/PricingInteractive";

export const metadata: Metadata = {
  title: "Preços | ADVOPACK — Modelos de Contratação",
  description:
    "Conheça os modelos de contratação da ADVOPACK: projetos sob medida, integrações específicas e licenciamento com suporte. Sem planos engessados.",
  keywords:
    "preço sistema personalizado, orçamento software, contratação desenvolvimento sistemas, ERP sob medida preço",
};

export default function PricingPage() {
  return (
    <main className="min-h-screen bg-[#F8F9FF]">
      <Header />
      <PricingInteractive />
      <Footer />
    </main>
  );
}