"use client";

import { useEffect, useRef } from "react";
import Icon from "@/components/ui/AppIcon";

const features = [
  {
    icon: "WrenchScrewdriverIcon" as const,
    title: "Desenvolvimento Sob Medida",
    description:
      "Cada sistema é construído do zero, mapeando exatamente os processos da sua empresa. Nenhum módulo desnecessário, nenhuma limitação imposta.",
    metrics: "100% personalizado",
    color: "#011363",
    bg: "#EEF0FA",
  },
  {
    icon: "ArrowsPointingInIcon" as const,
    title: "Integração com APIs",
    description:
      "Conectamos seu sistema a qualquer plataforma — ERP, e-commerce, gateways de pagamento, ERPs fiscais, marketplaces e muito mais.",
    metrics: "200+ integrações",
    color: "#2563EB",
    bg: "#EFF6FF",
  },
  {
    icon: "BoltIcon" as const,
    title: "Automação de Processos",
    description:
      "Elimine tarefas repetitivas com fluxos automatizados. Notificações, aprovações, geração de documentos e relatórios — tudo no piloto automático.",
    metrics: "Redução de 70% no retrabalho",
    color: "#0A1F8F",
    bg: "#EEF0FA",
  },
  {
    icon: "ArrowTrendingUpIcon" as const,
    title: "Escalabilidade Total",
    description:
      "Seu sistema cresce com o seu negócio. Arquitetura robusta que suporta desde pequenas operações até grandes volumes de dados e usuários.",
    metrics: "Infraestrutura cloud-ready",
    color: "#1D4ED8",
    bg: "#EFF6FF",
  },
];

export default function FeaturesSection() {
  const sectionRef = useRef<HTMLElement>(null);

  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            entry.target.querySelectorAll(".reveal-hidden").forEach((el) => {
              el.classList.remove("reveal-hidden");
            });
          }
        });
      },
      { threshold: 0.1 }
    );
    if (sectionRef.current) observer.observe(sectionRef.current);
    return () => observer.disconnect();
  }, []);

  return (
    <section ref={sectionRef} className="py-24 bg-white" id="features">
      <div className="max-w-7xl mx-auto px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-16 reveal reveal-hidden">
          <div className="section-label inline-flex mb-4">
            <Icon name="StarIcon" size={14} />
            Nossas Capacidades
          </div>
          <h2 className="font-heading text-4xl lg:text-5xl font-bold text-[#0D1340] tracking-tight mt-4">
            Tecnologia que{" "}
            <span className="gradient-text">transforma operações</span>
          </h2>
          <p className="text-[#6B7280] text-lg mt-4 max-w-2xl mx-auto leading-relaxed">
            Combinamos análise profunda da sua operação com desenvolvimento ágil
            para entregar sistemas que realmente funcionam para você.
          </p>
        </div>

        {/* Feature Grid */}
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
          {features.map((feature, i) => (
            <div
              key={feature.title}
              className={`feature-card p-6 reveal reveal-hidden reveal-delay-${i + 1}`}
            >
              {/* Icon */}
              <div
                className="w-14 h-14 rounded-2xl flex items-center justify-center mb-5"
                style={{ background: feature.bg }}
              >
                <Icon
                  name={feature.icon}
                  size={28}
                  className="text-[#011363]"
                />
              </div>

              {/* Content */}
              <h3 className="font-heading font-bold text-lg text-[#0D1340] mb-3 leading-snug">
                {feature.title}
              </h3>
              <p className="text-sm text-[#6B7280] leading-relaxed mb-5">
                {feature.description}
              </p>

              {/* Metric Badge */}
              <div
                className="inline-flex items-center gap-1.5 text-xs font-semibold px-3 py-1.5 rounded-full"
                style={{
                  color: feature.color,
                  background: feature.bg,
                }}
              >
                <Icon name="CheckCircleIcon" size={12} />
                {feature.metrics}
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}