"use client";

import { useEffect, useRef } from "react";
import Link from "next/link";
import Icon from "@/components/ui/AppIcon";

export default function CtaBanner() {
  const sectionRef = useRef<HTMLElement>(null);

  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            entry.target.querySelectorAll(".reveal-hidden").forEach((el) => {
              el.classList.remove("reveal-hidden");
            });
          }
        });
      },
      { threshold: 0.1 }
    );
    if (sectionRef.current) observer.observe(sectionRef.current);
    return () => observer.disconnect();
  }, []);

  return (
    <section
      ref={sectionRef}
      className="py-24 relative overflow-hidden"
      id="contact"
      style={{
        background: "linear-gradient(135deg, #010D45 0%, #011363 40%, #0A1F8F 100%)",
      }}
    >
      {/* Background decoration */}
      <div
        className="absolute top-0 right-0 w-96 h-96 rounded-full opacity-10"
        style={{
          background: "radial-gradient(circle, #2563EB 0%, transparent 70%)",
          transform: "translate(30%, -30%)",
        }}
      />
      <div
        className="absolute bottom-0 left-0 w-80 h-80 rounded-full opacity-10"
        style={{
          background: "radial-gradient(circle, #9ea3ba 0%, transparent 70%)",
          transform: "translate(-30%, 30%)",
        }}
      />

      {/* Grid overlay */}
      <div
        className="absolute inset-0 opacity-5"
        style={{
          backgroundImage:
            "linear-gradient(to right, white 1px, transparent 1px), linear-gradient(to bottom, white 1px, transparent 1px)",
          backgroundSize: "48px 48px",
        }}
      />

      <div className="relative z-10 max-w-4xl mx-auto px-6 lg:px-8 text-center">
        {/* Badge */}
        <div
          className="inline-flex items-center gap-2 text-xs font-bold uppercase tracking-widest text-white/70 border border-white/20 rounded-full px-4 py-2 mb-8 reveal reveal-hidden"
        >
          <Icon name="RocketLaunchIcon" size={14} />
          Pronto para começar?
        </div>

        {/* Headline */}
        <h2
          className="font-heading text-4xl lg:text-5xl xl:text-6xl font-extrabold text-white tracking-tight leading-tight mb-6 reveal reveal-hidden reveal-delay-1"
        >
          Seu próximo sistema{" "}
          <span className="text-[#9ea3ba]">começa com uma conversa.</span>
        </h2>

        <p
          className="text-white/70 text-lg leading-relaxed mb-10 max-w-2xl mx-auto reveal reveal-hidden reveal-delay-2"
        >
          Fale com nossos especialistas, descreva sua operação e receba uma
          proposta personalizada sem compromisso. Transformamos sua demanda em
          tecnologia que funciona.
        </p>

        {/* CTA Buttons */}
        <div className="flex flex-col sm:flex-row gap-4 justify-center reveal reveal-hidden reveal-delay-3">
          <a
            href="mailto:contato@advopack.com.br"
            className="inline-flex items-center justify-center gap-2 bg-white text-[#011363] font-heading font-bold py-4 px-8 rounded-xl hover:bg-[#EEF0FA] transition-all duration-300 hover:-translate-y-1 hover:shadow-lg text-sm"
          >
            <Icon name="EnvelopeIcon" size={18} />
            Solicitar Demonstração
          </a>
          <Link
            href="/systems"
            className="inline-flex items-center justify-center gap-2 bg-white/10 text-white font-heading font-semibold py-4 px-8 rounded-xl border border-white/20 hover:bg-white/20 transition-all duration-300 hover:-translate-y-1 text-sm"
          >
            Ver Sistemas
            <Icon name="ArrowRightIcon" size={18} />
          </Link>
        </div>

        {/* Trust Row */}
        <div
          className="flex flex-wrap items-center justify-center gap-6 mt-12 pt-10 border-t border-white/10 reveal reveal-hidden reveal-delay-4"
        >
          {[
            { icon: "ShieldCheckIcon" as const, text: "Sem contrato de fidelidade" },
            { icon: "ClockIcon" as const, text: "Resposta em 24h" },
            { icon: "ChatBubbleLeftIcon" as const, text: "Consultoria gratuita" },
          ].map((item) => (
            <div key={item.text} className="flex items-center gap-2 text-white/60 text-sm">
              <Icon name={item.icon} size={16} className="text-white/40" />
              {item.text}
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}