import React, { useState } from 'react';
import { useHistory } from 'react-router-dom';
import AdminContainer from '../../../../components/Admin/Container';
import FormCategoryAdmin from '../../../../components/Admin/FormCategory';
import ButtonsForm from '../../../../components/Admin/ButtonsForm';
import ValidationErrorsContainer from '../../../../components/Shared/ValidationErrorsContainer';
import validationSchema from '../../../../services/validations/validationCategoryAdmin';
import CategoryApiService from '../../../../services/api/CategoryApiService';

function CategoriesNew() {
  const history = useHistory();

  const [values, setValues] = useState({
    name: '',
    description: '',
  });
  const [isSaving, setIsSaving] = useState(false);
  const [errors, setErrors] = useState([]);

  const handleSubmit = async () => {
    setIsSaving(true);
    const form = {
      ...values,
    };
    try {
      const isValid = await validationSchema
        .validate(form, { abortEarly: false })
        .then(() => {
          setErrors([]);
          return true;
        })
        .catch((err) => {
          setErrors([...err.errors]);
          return undefined;
        });
      if (isValid !== undefined) {
        const resp = await CategoryApiService.createNew(form).then(
          (r) => r.data
        );
        if (resp.success) {
          history.push('/admin/categorias/page/1');
        } else {
          throw new Error(`Failed to create category: ${resp.error}`);
        }
      }
    } catch (e) {
      console.error(e);
    } finally {
      setIsSaving(false);
    }
  };

  const handleClearErrors = () => {
    setErrors([]);
  };

  return (
    <AdminContainer link="categorias">
      <ButtonsForm
        path="/admin/categorias/page/1"
        handleSubmit={handleSubmit}
        isNew
        isSaving={isSaving}
      />
      <ValidationErrorsContainer
        errors={[...errors]}
        clear={handleClearErrors}
      />
      <FormCategoryAdmin values={values} update={setValues} />
    </AdminContainer>
  );
}

export default CategoriesNew;
