<p align="center" id="sobre"><img src="./SPA/src/assets/img/bee-logo-color.svg" width="200px"/></p>

<h1 align="center">Business Enterprise E-commerce</h1>

<p align="justify">
    O sistema BEE (Business Enterprise E-commerce) é um projeto
    desenvolvido para a matéria de Laboratório de Programação Web 2 do
    curso de Análise e Desenvolvimento de Sistemas. Ele tem o intuito de
    ser um sistema de e-commerce com a parte do administrador, que
    gerencia os produtos, categorias, promoções, banners e vendas, além de
    conseguir gerar um relatório mensal. Na parte do cliente, ele é capaz
    de visualizar os produtos, gerenciar seus dados, cartões e endereços,
    realizar uma compra e visualizar os detalhes dos pedidos efetuados.
</p>

<p align="center">
  <img src="https://img.shields.io/badge/MIT-FCA311?style=flat-square&label=License&Color=white&labelColor=0D1117" />
  <img src="https://img.shields.io/github/repo-size/WebII-2020-2/BEE?color=FCA311&label=Repo%20Size&style=flat-square&labelColor=0D1117" />
  <img src="https://img.shields.io/github/last-commit/WebII-2020-2/BEE?color=FCA311&label=Last%20Commit&style=flat-square&labelColor=0D1117" />
  <img src="https://img.shields.io/badge/Stable-FCA311?style=flat-square&label=Status&Color=white&labelColor=0D1117" />
<img src="https://img.shields.io/badge/v1.0-FCA311?style=flat-square&label=Version&Color=white&labelColor=0D1117" />
</p>

<p align="center">
  <a href="#sobre">Sobre</a> •
  <a href="#tecnologias">Tecnologias</a> •
  <a href="#links">Links úteis</a> •
  <a href="#licenca">Licença</a> •
  <a href="#screenshots">Screenshots</a> •
  <a href="#autores">Autores</a>
</p>

<h2 id="tecnologias">Tecnologias</h2>

<h3>Front-End</h3>
<p align="center">
  <img src="https://img.shields.io/badge/-React-0D1117?style=for-the-badge&logo=react" />
  <img src="https://img.shields.io/badge/-Redux-0D1117?style=for-the-badge&logo=redux" />
  <img src="https://img.shields.io/badge/-Bootstrap-0D1117?style=for-the-badge&logo=bootstrap" />
    <img src="https://img.shields.io/badge/-Vercel-0D1117?style=for-the-badge&logo=vercel" />

</p>

<p align="justify">
    O front-end foi foi produzido em forma de SPA com a biblioteca
    React.JS e o framework Bootstrap. Para consumo dos dados da API foi
    utilizado o Axios e Redux para persistência de dados pela aplicação.
    Também foram utilizadas bibliotecas de validação e CPF e Cartão de
    Crédito, além de consulta de endereço por CEP. O deploy da SPA foi realizado no Vercel.
</p>

<h3>Back-End</h3>

<p align="center">
  <img src="https://img.shields.io/badge/-laravel-0D1117?style=for-the-badge&logo=laravel" />
  <img src="https://img.shields.io/badge/-mysql-0D1117?style=for-the-badge&logo=mysql" />
  <img src="https://img.shields.io/badge/-google_cloud-0D1117?style=for-the-badge&logo=googlecloud" />
  <img src="https://img.shields.io/badge/-heroku-0D1117?style=for-the-badge&logo=heroku" />
</p>

<p align="justify">
    A parte do back-end do projeto foi construída no modelo de API REST e
    arquitetura MVC. Para isso, foram utilizados o framework Laravel e a
    persistência dos dados feita com a ajuda do MySQL e Google Cloud. O deploy da API foi realizado no Heroku.
</p>

<h2 id="links">Links úteis</h2>

Abaixo, segue uma lista com links e documentos úteis.

- <a href="https://github.com/WebII-2020-2/BEE/blob/main/docs/documentacaoEndpoints.md">Documentação dos Endpoints</a>
- <a href="https://github.com/WebII-2020-2/BEE/blob/main/docs/deployAPI.md">Instalação da API</a>
- <a href="https://github.com/WebII-2020-2/BEE/blob/main/docs/deploySPA.md">Instalação da SPA</a>
- <a href="https://www.figma.com/file/9XUhANzTUsepjryBKGDBi0/BEE?node-id=0%3A1">Protótipo de telas do Figma</a>
- <a href="https://github.com/WebII-2020-2/BEE/blob/main/docs/diagramaDeEntidadeRelacionamento.pdf">Modelo Entidade e Relacionamento</a>
- <a href="https://github.com/WebII-2020-2/BEE/blob/main/docs/documentoDeRequisitos.pdf">Documento de Requisitos</a>

<h2 id="licenca">Licença</h2>

<p  align="justify">
Este projeto está sob licença do MIT que permite a qualquer pessoa que obtém uma cópia do software e seus arquivos de documentação associados poder lidar com eles sem restrição ou limitação aos direitos de uso. As condições impostas são de apenas manter o aviso de copyright e uma cópia da <a href="https://github.com/WebII-2020-2/BEE/blob/main/LICENSE">licença</a> em todas as reproduções do software.
</p>

<h2 id="screenshots">Screenshots</h2>

<div align="center">

Tela inicial do sistema
<img src="./screenshots/home-bee.png" alt="Tela inicial do sistema" />

Login do usuário
<img src="./screenshots/login-user.png" alt="Tela de login do usuário" />

Informações do produto
<img src="./screenshots/product-bee.png" alt="Tela dos detalhes do produto" />

Carrinho de compras
<img src="./screenshots/cart-bee.png" alt="Carrinho de compras do sistema" />

Revisão de compra
<img src="./screenshots/shopping-bee.png" alt="Tela de revisão de compra" />

Login do administrador
<img src="./screenshots/login-admin.png" alt="Tela de login do administrador" />

Tela inicial da parte do administrador
<img src="./screenshots/home-admin.png" alt="Tela inicial da parte do administrador" />
</div>

<h2 id="autores">Autores</h2>

<table align="center">
    <tr>
        <td align="center">
            <a href="https://github.com/aldeirnohan">
                <img style="border-radius: 50%;" src="https://avatars.githubusercontent.com/u/47931404?v=4" width="80px;" alt="Foto de Claudio Henrique"/>
                <br/>
                <b>Aldeir Nohan</b>
            </a>
        </td>
        <td align="center">
            <a href="https://github.com/claudiohenriquefds">
                <img style="border-radius: 50%;" src="https://avatars1.githubusercontent.com/u/30199497?v=4" width="80px;" alt="Foto de Claudio Henrique"/>
                <br/>
                <b>Cláudio Henrique</b>
            </a>
        </td>
        <td align="center">
            <a href="https://github.com/marciosamuel">
                <img style="border-radius: 50%;" src="https://avatars1.githubusercontent.com/u/43766556?v=4" width="80px;" alt="Foto de Marcio Samuel"/>
                <br/>
                <b>Marcio Samuel</b>
            </a>
        </td>
        <td align="center">
            <a href="https://github.com/mateusgs29">
                <img style="border-radius: 50%;" src="https://avatars.githubusercontent.com/u/61122185?v=4" width="80px;" alt="Foto de Mateus Gomes"/>
                <br/>
                <b>Mateus Gomes</b>
            </a>
        </td>
    </tr>
</table>
