<?php
include '../autentica.php';
include '../conexao.php';
if ($usuario['tipo'] != 'admin') exit('Acesso negado');

$query = $pdo->query("SELECT id, nome, email, tipo FROM usuarios ORDER BY id DESC");
$usuarios = $query->fetchAll(PDO::FETCH_ASSOC);
?>

<h2>Todos os Usuários</h2>
<table>
  <thead>
    <tr><th>ID</th><th>Nome</th><th>Email</th><th>Tipo</th><th>Ações</th></tr>
  </thead>
  <tbody>
    <?php foreach ($usuarios as $u): ?>
      <tr>
        <td><?= htmlspecialchars($u['id']) ?></td>
        <td><?= htmlspecialchars($u['nome']) ?></td>
        <td><?= htmlspecialchars($u['email']) ?></td>
        <td><?= htmlspecialchars($u['tipo']) ?></td>
        <td>
          <!-- Você pode colocar botões de editar, excluir etc -->
          <button onclick="alert('Editar ID <?= $u['id'] ?>')">Editar</button>
          <button onclick="alert('Excluir ID <?= $u['id'] ?>')">Excluir</button>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<style>
  /* Copie o estilo #aba-usuarios daqui para manter o visual */
  h2 {
    font-size: 1.8rem;
    margin-bottom: 20px;
    color: #2c3e50;
    border-bottom: 3px solid #2980b9;
    padding-bottom: 8px;
  }
  table {
    width: 100%;
    border-collapse: collapse;
    font-size: 1rem;
    color: #34495e;
    background: #fff;
  }
  thead th {
    background-color: #2980b9;
    color: white;
    text-align: left;
    padding: 14px 20px;
    user-select: none;
  }
  tbody tr {
    border-bottom: 1px solid #ddd;
    transition: background-color 0.25s ease;
  }
  tbody tr:hover {
    background-color: #ecf6fd;
  }
  tbody td {
    padding: 14px 20px;
  }
</style>
