<h2>Cadastrar Novo Usuário</h2>
<form id="form-cadastrar-usuario">
  <label>Nome: <input type="text" name="nome" required></label>
  <label>Email: <input type="email" name="email" required></label>
  <label>Tipo:
    <select name="tipo" required>
      <option value="admin">Admin</option>
      <option value="restaurante">Restaurante</option>
      <option value="motoboy">Motoboy</option>
    </select>
  </label>
  <label>Senha: <input type="password" name="senha" required></label>
  <input type="hidden" name="acao" value="cadastrar_usuario">
  <button type="submit">Cadastrar</button>
</form>
<div id="msg-cadastro" class="msg-sucesso"></div>

<style>
  h2 {
    font-size: 1.8rem;
    margin-bottom: 20px;
    color: #2c3e50;
    border-bottom: 3px solid #2980b9;
    padding-bottom: 8px;
  }
  form {
    display: flex;
    flex-direction: column;
    gap: 15px;
    max-width: 400px;
  }
  label {
    display: flex;
    flex-direction: column;
    font-weight: 600;
    color: #2c3e50;
  }
  input, select {
    padding: 8px 10px;
    font-size: 1rem;
    border: 1px solid #ccc;
    border-radius: 4px;
  }
  button {
    width: 140px;
    padding: 10px;
    background: #2980b9;
    color: #fff;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-weight: 700;
  }
  button:hover {
    background: #3498db;
  }
  .msg-sucesso {
    margin-top: 15px;
    color: green;
  }
  .msg-erro {
    margin-top: 15px;
    color: red;
  }
</style>

<script>
  $('#form-cadastrar-usuario').submit(function(e){
    e.preventDefault();
    const dados = $(this).serialize();
    $.post('cadastrar_usuario.php', dados, function(resposta){
      if(resposta.status === 'ok') {
        $('#msg-cadastro').removeClass('msg-erro').addClass('msg-sucesso').text('Usuário cadastrado com sucesso!');
        $('#form-cadastrar-usuario')[0].reset();
      } else {
        $('#msg-cadastro').removeClass('msg-sucesso').addClass('msg-erro').text('Erro: ' + resposta.msg);
      }
    }, 'json');
  });
</script>
