<?php
include('conexao.php');

// Define o primeiro e o último dia do mês atual
$data_inicio = date('Y-m-01');
$data_fim = date('Y-m-t 23:59:59'); // último dia do mês, até o final do dia

$sql = "SELECT COUNT(*) as total FROM entregas 
        WHERE status = 'ACEITA' 
        AND criado_em BETWEEN :inicio AND :fim";

$stmt = $pdo->prepare($sql);
$stmt->execute([
    ':inicio' => $data_inicio,
    ':fim' => $data_fim
]);

$result = $stmt->fetch(PDO::FETCH_ASSOC);

echo json_encode(['total' => $result['total'] ?? 0]);
