<?php
session_start();
require 'conexao.php'; // ajuste o caminho conforme sua estrutura

// Verifica se o admin está logado
if (!isset($_SESSION['usuario']['id'])) {
    echo "Usuário não autenticado.";
    exit;
}

$id_admin = $_SESSION['usuario']['id'];
$nome = trim($_POST['nome'] ?? '');
$email = trim($_POST['email'] ?? '');
$senha = trim($_POST['senha'] ?? '');

// Validações simples
if (empty($nome) || empty($email)) {
    echo "Nome e email são obrigatórios.";
    exit;
}

// Verifica se o email já existe para outro usuário
$sql = $pdo->prepare("SELECT id FROM usuarios WHERE email = :email AND id != :id");
$sql->execute([':email' => $email, ':id' => $id_admin]);
if ($sql->fetch()) {
    echo "Email já está em uso por outro usuário.";
    exit;
}

// Lógica para upload de imagem
if (isset($_FILES['foto']) && $_FILES['foto']['error'] === 0) {
    $ext_permitidas = ['jpg', 'jpeg', 'png', 'gif'];
    $extensao = strtolower(pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION));

    if (in_array($extensao, $ext_permitidas)) {
        $caminho_destino = 'img/perfiladmin.png'; // nome fixo
        move_uploaded_file($_FILES['foto']['tmp_name'], $caminho_destino);
    } else {
        echo "Formato de imagem não permitido. Use JPG, PNG ou GIF.";
        exit;
    }
}

try {
    if (!empty($senha)) {
        // Atualiza nome, email e senha (criptografada)
        $senha_hash = password_hash($senha, PASSWORD_DEFAULT);
        $sql = $pdo->prepare("UPDATE usuarios SET nome = :nome, email = :email, senha = :senha WHERE id = :id");
        $sql->execute([
            ':nome' => $nome,
            ':email' => $email,
            ':senha' => $senha_hash,
            ':id' => $id_admin
        ]);
    } else {
        // Atualiza só nome e email
        $sql = $pdo->prepare("UPDATE usuarios SET nome = :nome, email = :email WHERE id = :id");
        $sql->execute([
            ':nome' => $nome,
            ':email' => $email,
            ':id' => $id_admin
        ]);
    }

    echo "Perfil atualizado com sucesso!";
} catch (Exception $e) {
    echo "Erro ao atualizar perfil: " . $e->getMessage();
}
?>
