<?php
include 'autentica.php';
include 'conexao.php';

$stmt = $pdo->query("
  SELECT tb.id, u.nome AS restaurante, b.nome AS bairro, tb.taxa
  FROM taxas_bairros tb
  JOIN usuarios u ON u.id = tb.estabelecimento_id
  JOIN bairros b ON b.id = tb.bairro_id
  ORDER BY u.nome, b.nome
");

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
  echo "<tr>
          <td>" . htmlspecialchars($row['restaurante']) . "</td>
          <td>" . htmlspecialchars($row['bairro']) . "</td>
          <td>R$ " . number_format($row['taxa'], 2, ',', '.') . "</td>
          <td>
            <button class='btn-editar btn btn-sm btn-warning' data-id='{$row['id']}' data-estabelecimento='{$row['restaurante']}' data-bairro='{$row['bairro']}' data-taxa='{$row['taxa']}'>Editar</button>
          </td>
        </tr>";
}
