<?php
include 'autentica.php';
include 'conexao.php';
require_once 'dompdf/autoload.inc.php';

use Dompdf\Dompdf;

if ($usuario['tipo'] != 'restaurante') exit('Acesso negado');

$motoboy = $_GET['motoboy'] ?? '';
$data_ini = $_GET['data_ini'] ?? '';
$data_fim = $_GET['data_fim'] ?? '';
$status = $_GET['status'] ?? '';

// Valida0400o: se filtrar por data, motoboy  obrigatrio
if (($data_ini || $data_fim) && !$motoboy) {
    die('Para filtrar por data,  obrigatrio selecionar um motoboy.');
}

$params = [];
$sql = "
  SELECT e.*, u.nome AS motoboy_nome
  FROM entregas e
  LEFT JOIN usuarios u ON e.motoboy_id = u.id
  WHERE e.restaurante_id = ?
";
$params[] = $usuario['id'];

if (!empty($motoboy)) {
  $sql .= " AND e.motoboy_id = ?";
  $params[] = $motoboy;
}

if (!empty($status)) {
  $sql .= " AND e.status = ?";
  $params[] = $status;
}

if (!empty($data_ini)) {
  $sql .= " AND DATE(e.criado_em) >= ?";
  $params[] = $data_ini;
}

if (!empty($data_fim)) {
  $sql .= " AND DATE(e.criado_em) <= ?";
  $params[] = $data_fim;
}

$sql .= " ORDER BY e.criado_em DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$entregas = $stmt->fetchAll();

$html = "<h2>Relatrio de Entregas - Restaurante: " . htmlspecialchars($usuario['nome']) . "</h2>";

if ($motoboy || $data_ini || $data_fim || $status) {
  $html .= "<p><strong>Filtros aplicados:</strong><br>";
  if ($motoboy) {
    $nomeMotoboy = $pdo->prepare("SELECT nome FROM usuarios WHERE id = ?");
    $nomeMotoboy->execute([$motoboy]);
    $motoboyNome = $nomeMotoboy->fetchColumn();
    $html .= "Motoboy: " . htmlspecialchars($motoboyNome) . "<br>";
  }
  if ($status) {
    $html .= "Status: " . htmlspecialchars($status) . "<br>";
  }
  if ($data_ini) {
    $html .= "Data Inicial: " . date('d/m/Y', strtotime($data_ini)) . "<br>";
  }
  if ($data_fim) {
    $html .= "Data Final: " . date('d/m/Y', strtotime($data_fim)) . "<br>";
  }
  $html .= "</p>";
}

if (!$entregas) {
  $html .= "<p>Nenhuma entrega encontrada com os filtros aplicados.</p>";
} else {
  $html .= "<table border='1' cellpadding='6' cellspacing='0' style='width:100%; border-collapse: collapse;'>
    <tr>
      <th>Data</th>
      <th>Destino</th>
      <th>Status</th>
      <th>Motoboy</th>
      <th>Taxa</th>
    </tr>";

  $total = 0;

  foreach ($entregas as $e) {
    $taxa = number_format($e['taxa'], 2, ',', '.');
    $total += $e['taxa'];

    $html .= "<tr>
      <td>" . date('d/m/Y H:i', strtotime($e['criado_em'])) . "</td>
      <td>" . htmlspecialchars($e['destino']) . "</td>
      <td>" . htmlspecialchars($e['status']) . "</td>
      <td>" . htmlspecialchars($e['motoboy_nome'] ?? 'N/A') . "</td>
      <td>R$ {$taxa}</td>
    </tr>";
  }

  $html .= "<tr style='font-weight:bold; background:#f0f0f0;'>
    <td colspan='4' style='text-align:right;'>Total de entregas:</td>
    <td>R$ " . number_format($total, 2, ',', '.') . "</td>
  </tr>";
  $html .= "</table>";
}

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("entregas_restaurante.pdf", ["Attachment" => true]);
