<?php
require_once('tcpdf_include.php'); // Ajuste o caminho para sua lib TCPDF
require_once('conexao.php'); // conexão PDO

// Recebe os filtros via GET ou POST (exemplo)
$motoboy_id = $_GET['motoboy_id'] ?? null;
$data_inicio = $_GET['data_inicio'] ?? null;
$data_fim = $_GET['data_fim'] ?? null;
$status = $_GET['status'] ?? null;

// Monta a query com filtros (exemplo simplificado)
$sql = "SELECT valor, status FROM entregas WHERE 1=1 ";
$params = [];

if ($motoboy_id) {
    $sql .= " AND motoboy_id = :motoboy_id ";
    $params[':motoboy_id'] = $motoboy_id;
}
if ($data_inicio) {
    $sql .= " AND data_entrega >= :data_inicio ";
    $params[':data_inicio'] = $data_inicio;
}
if ($data_fim) {
    $sql .= " AND data_entrega <= :data_fim ";
    $params[':data_fim'] = $data_fim;
}
if ($status) {
    $sql .= " AND status = :status ";
    $params[':status'] = $status;
}

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$entregas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Calcula valores
$valor_bruto = 0;
$entregas_realizadas = 0;

foreach ($entregas as $entrega) {
    $valor_bruto += floatval($entrega['valor']);
    if ($entrega['status'] === 'realizada') {
        $entregas_realizadas++;
    }
}

$valor_a_pagar = $valor_bruto - (2 * $entregas_realizadas);

// Começa o PDF
$pdf = new TCPDF();
$pdf->AddPage();
$pdf->SetFont('helvetica', '', 12);

$pdf->Cell(0, 10, 'Relatório de Entregas', 0, 1, 'C');
$pdf->Ln(5);

// Cabeçalho da tabela
$pdf->Cell(40, 10, 'Valor', 1);
$pdf->Cell(40, 10, 'Status', 1);
$pdf->Ln();

// Dados
foreach ($entregas as $entrega) {
    $pdf->Cell(40, 10, 'R$ ' . number_format($entrega['valor'], 2, ',', '.'), 1);
    $pdf->Cell(40, 10, $entrega['status'], 1);
    $pdf->Ln();
}

// Espaço antes do resumo
$pdf->Ln(5);

// Resumo dos valores
$pdf->Cell(0, 10, 'Resumo', 0, 1, 'L');
$pdf->Cell(80, 10, 'Valor bruto:', 0);
$pdf->Cell(40, 10, 'R$ ' . number_format($valor_bruto, 2, ',', '.'), 0, 1);

$pdf->Cell(80, 10, 'Entregas realizadas:', 0);
$pdf->Cell(40, 10, $entregas_realizadas, 0, 1);

$pdf->Cell(80, 10, 'Desconto (R$ 2,00 por entrega):', 0);
$pdf->Cell(40, 10, 'R$ ' . number_format($entregas_realizadas * 2, 2, ',', '.'), 0, 1);

$pdf->Cell(80, 10, 'Valor a pagar:', 0);
$pdf->Cell(40, 10, 'R$ ' . number_format($valor_a_pagar, 2, ',', '.'), 0, 1);

$pdf->Output('relatorio_entregas.pdf', 'I');
