<?php
session_start();
require 'conexao.php';

$usuario = $_SESSION['usuario'] ?? null;

if (!$usuario || !isset($usuario['id'])) {
    echo 'Usuário não autenticado.';
    exit;
}

$id = $usuario['id'];
$nome = $_POST['nome'] ?? '';
$email = $_POST['email'] ?? '';
$senha = $_POST['senha'] ?? '';

if (empty($nome) || empty($email)) {
    echo 'Nome e e-mail são obrigatórios.';
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo 'E-mail inválido.';
    exit;
}

if (!empty($senha)) {
    $senha_criptografada = password_hash($senha, PASSWORD_DEFAULT);
    $sql = $pdo->prepare("UPDATE usuarios SET nome = :nome, email = :email, senha = :senha WHERE id = :id");
    $sql->execute([
        ':nome' => $nome,
        ':email' => $email,
        ':senha' => $senha_criptografada,
        ':id' => $id
    ]);
} else {
    $sql = $pdo->prepare("UPDATE usuarios SET nome = :nome, email = :email WHERE id = :id");
    $sql->execute([
        ':nome' => $nome,
        ':email' => $email,
        ':id' => $id
    ]);
}

// Atualizar a sessão
$_SESSION['usuario']['nome'] = $nome;
$_SESSION['usuario']['email'] = $email;

echo 'Perfil atualizado com sucesso.';
