<?php
include('conexao.php');

$sql = "SELECT 
            COUNT(*) as total,
            SUM(CASE WHEN tipo = 'motoboy' THEN 1 ELSE 0 END) as total_motoboy,
            SUM(CASE WHEN tipo = 'restaurante' THEN 1 ELSE 0 END) as total_restaurante
        FROM usuarios";

$stmt = $pdo->prepare($sql);
$stmt->execute();
$result = $stmt->fetch(PDO::FETCH_ASSOC);

echo json_encode([
    'total' => $result['total'] ?? 0,
    'motoboy' => $result['total_motoboy'] ?? 0,
    'restaurante' => $result['total_restaurante'] ?? 0
]);
