<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'].'/conexao.php';  // Certifique-se de que o caminho está correto

// Verificar se o usuário está logado
if (!isset($_SESSION['usuario'])) {
    die("Erro: Usuário não autenticado.");
}

// Obter o ID do usuário logado
$user_id = $_SESSION['usuario']['id'];  // Acessando diretamente o ID do usuário logado no array de sessão

// Preparar a consulta para buscar as conversas do usuário logado
$sql = "SELECT c.id, 
                IF(c.id_usuario1 = :user_id, u2.nome, u1.nome) AS usuario_comum, 
                c.ultimo_mensagem 
        FROM conversas c
        JOIN usuarios u1 ON u1.id = c.id_usuario1
        JOIN usuarios u2 ON u2.id = c.id_usuario2
        WHERE c.id_usuario1 = :user_id OR c.id_usuario2 = :user_id";  // Verificando se o usuário está envolvido

// Preparar a consulta com PDO
$stmt = $pdo->prepare($sql);

// Associar o parâmetro :user_id ao valor de $user_id
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);

// Executar a consulta
$stmt->execute();

// Criar o array para armazenar as conversas
$chats = [];

// Buscar as conversas
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $chats[] = $row;
}

// Retornar as conversas em formato JSON
echo json_encode($chats);

?>
