<?php
session_start();
require 'conexao.php';

$restaurante_id = $_SESSION['usuario']['id'] ?? null;

if (!$restaurante_id) {
    echo "<option>Nenhum bairro encontrado - restaurante no identificado</option>";
    exit;
}

$query = $pdo->prepare("SELECT * FROM bairros_taxas WHERE estabelecimento_id = :id");
$query->bindValue(':id', $restaurante_id);
$query->execute();

$dados = $query->fetchAll(PDO::FETCH_ASSOC);

if (count($dados) === 0) {
    echo "<option>Nenhum bairro encontrado para este restaurante</option>";
} else {
    foreach ($dados as $bairro) {
        echo "<option value='{$bairro['id']}'>{$bairro['nome_bairro']}</option>";
    }
}
