<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['usuario']) || $_SESSION['usuario']['tipo'] != 'motoboy') {
  exit('Acesso negado');
}

$motoboy_id = $_SESSION['usuario']['id'];
$entrega_id = $_POST['id'] ?? null;

if ($entrega_id) {
  $sql = $pdo->prepare("
    UPDATE entregas 
    SET 
      motoboy_id = :motoboy_id, 
      status = 'aceita', 
      aceita_em = NOW()
    WHERE 
      id = :entrega_id 
      AND status = 'pendente' 
      AND motoboy_id IS NULL
  ");
  
  $sql->execute([
    ':motoboy_id' => $motoboy_id,
    ':entrega_id' => $entrega_id
  ]);

  if ($sql->rowCount() == 1) {
    // Buscar dados da entrega e do motoboy
    $sql_entrega = $pdo->prepare("SELECT * FROM entregas WHERE id = :entrega_id");
    $sql_entrega->execute([':entrega_id' => $entrega_id]);
    $entrega = $sql_entrega->fetch();
    
    // Buscar nome do motoboy
    $sql_motoboy = $pdo->prepare("SELECT nome FROM usuarios WHERE id = :motoboy_id");
    $sql_motoboy->execute([':motoboy_id' => $motoboy_id]);
    $motoboy = $sql_motoboy->fetch();
    $nome_motoboy = $motoboy['nome'] ?? 'Motoboy desconhecido';
    
    // Dados da entrega
    $destino = $entrega['destino'];
    $bairro_id = $entrega['bairro_id'];
    $taxa = $entrega['taxa'];
    $valor_liquido = $entrega['valor_liquido'];
    $disponivel_em = $entrega['disponivel_em'];
    $bairro = $pdo->prepare("SELECT nome_bairro FROM bairros_taxas WHERE id = :bairro_id");
    $bairro->execute([':bairro_id' => $bairro_id]);
    $bairro_data = $bairro->fetch();
    $nome_bairro = $bairro_data['nome_bairro'] ?? 'Bairro desconhecido';
    
    // Formatar o horário de coleta
    try {
        $data_obj = new DateTime($disponivel_em);
        $horario_formatado = $data_obj->format('H:i');
    } catch (Exception $e) {
        $horario_formatado = 'N/A'; // Caso o formato da data seja inválido
    }

    // ------------------------
    // ENVIO DA MENSAGEM WHATSAPP
    // ------------------------

    $api_whatsapp = 'menuia';
    $token_whatsapp = 'WlO7DvhCgXl5O6A19dCPpfa1EK2BLvYSA9HezIb2cvr5Sjrg49';
    $instancia_whatsapp = '9591f6a6-deab-4ea7-a951-fe99b4bd6ed0';
    $telefone_envio = '120363422825928968@g.us'; // número ou grupo

    function encode_com_underscore_preservando_virgula($texto) {
        $codificado = urlencode($texto);
        $codificado = str_replace('+', '_', $codificado); // espaços vira _
        $codificado = str_ireplace('%2C', ',', $codificado); // reverte vírgulas
        return $codificado;
    }

    // Montar a mensagem de aceitação
     $mensagem_whatsapp = '✅ *Entrega Aceita* ✅%0A';
    $mensagem_whatsapp .= '🛵 *Motoboy*: ' . encode_com_underscore_preservando_virgula($nome_motoboy) . '%0A';
    $mensagem_whatsapp .= '📦 *ID da Entrega*: ' . encode_com_underscore_preservando_virgula($entrega_id) . '%0A';
   
    
    require 'apis/texto.php';

    echo "Entrega aceita com sucesso!";
  } else {
    echo "Esta entrega já foi aceita por outro motoboy ou não está mais disponível.";
  }
} else {
  echo "ID da entrega inválido.";
}
?>



