<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/conexao.php';

header('Content-Type: application/json');

if (!isset($_POST['id'])) {
    echo json_encode(['sucesso' => false, 'mensagem' => 'ID não enviado']);
    exit;
}

$id = intval($_POST['id']);

try {
    // altera status para Excluido
    $sql = "UPDATE usuarios SET status = 'Excluido' WHERE id = :id AND tipo != 'admin'";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        echo json_encode(['sucesso' => true]);
    } else {
        echo json_encode(['sucesso' => false, 'mensagem' => 'Usuário não encontrado ou não pode ser excluído']);
    }
} catch (PDOException $e) {
    echo json_encode(['sucesso' => false, 'mensagem' => 'Erro: ' . $e->getMessage()]);
}
