<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/conexao.php'; // Caminho fixo para a conexão

if (isset($_GET['id'])) {
    $id = $_GET['id'];

    try {
        // Consulta para pegar os dados do usuário pelo ID
        $sql = "SELECT id, nome, email, tipo, status FROM usuarios WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();

        // Verifica se o usuário foi encontrado
        $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($usuario) {
            // Retornar os dados do usuário em formato JSON
            echo json_encode($usuario);
        } else {
            echo json_encode(["error" => "Usuário não encontrado"]);
        }
    } catch (PDOException $e) {
        echo "Erro na consulta: " . $e->getMessage();
    }
} else {
    echo json_encode(["error" => "ID do usuário não fornecido"]);
}
?>
