<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
require_once $_SERVER['DOCUMENT_ROOT'] . '/conexao.php'; // Caminho fixo para a conexão

// Definir o ID do restaurante como 1 (admin)
$restaurante_id = 1;  // O ID do administrador será sempre 1

// Receber os dados do formulário
$destino = $_POST['destino'] ?? '';
$bairro_id = $_POST['bairro_id'] ?? ''; // Corrigido para bairro_id
$taxa = $_POST['taxa'] ?? ''; // Taxa é um número
$valor_liquido = $_POST['valor_liquido'] ?? ''; // Receber o valor_liquido

// NOVO: Receber o novo campo 'disponivel_em' que o JavaScript envia
$disponivel_em = $_POST['disponivel_em'] ?? '';

// Validação dos campos obrigatórios
if (empty($destino) || empty($bairro_id) || empty($taxa) || empty($disponivel_em)) {
    echo "Destino, bairro, taxa e horário para coleta são obrigatórios.";
    exit;
}

// Inserir a nova entrega com os dados recebidos
$criado_em = date('Y-m-d H:i:s');
$sql = $pdo->prepare("INSERT INTO entregas (restaurante_id, destino, bairro_id, taxa, valor_liquido, status, criado_em, disponivel_em)
                       VALUES (:restaurante_id, :destino, :bairro_id, :taxa, :valor_liquido, 'pendente', :criado_em, :disponivel_em)");

$sql->execute([
    ':restaurante_id' => $restaurante_id, // ID fixo como 1
    ':destino' => $destino,
    ':bairro_id' => $bairro_id,  // Agora usando bairro_id
    ':taxa' => $taxa,      // A taxa agora é numérica
    ':valor_liquido' => $valor_liquido, // Inserir o valor líquido
    ':criado_em' => $criado_em,
    ':disponivel_em' => $disponivel_em
]);

$entrega_id = $pdo->lastInsertId();

// Buscar nome do estabelecimento (tabela 'usuarios')
$sql = $pdo->prepare("SELECT nome FROM usuarios WHERE id = :id");
$sql->execute([':id' => $restaurante_id]);
$usuario = $sql->fetch();
$nome_estabelecimento = $usuario['nome'] ?? 'Estabelecimento desconhecido';

// ------------------------
// ENVIO DA MENSAGEM WHATSAPP
// ------------------------

$api_whatsapp = 'menuia';

$token_whatsapp = 'WlO7DvhCgXl5O6A19dCPpfa1EK2BLvYSA9HezIb2cvr5Sjrg49';
$instancia_whatsapp = '9959c7a3-f59e-43a1-a6d7-9df026fdd247';
$telefone_envio = '120363420186411166@g.us'; // número ou grupo

function encode_com_underscore_preservando_virgula($texto) {
    $codificado = urlencode($texto);
    $codificado = str_replace('+', '_', $codificado); // espaços vira _ 
    $codificado = str_ireplace('%2C', ',', $codificado); // reverte vírgulas
    return $codificado;
}

// Formatar o horário para exibir na mensagem de forma amigável
try {
    $data_obj = new DateTime($disponivel_em);
    $horario_formatado = $data_obj->format('H:i');
} catch (Exception $e) {
    $horario_formatado = 'N/A'; // Caso o formato da data seja inválido
}

// Montar a mensagem adicionando o horário de coleta
$mensagem_whatsapp = '*Nova Entrega Cadastrada*%0A';
$mensagem_whatsapp .= '📦 ID da Entrega: ' . encode_com_underscore_preservando_virgula($entrega_id) . '%0A';
$mensagem_whatsapp .= '🏪 Estab.: ' . encode_com_underscore_preservando_virgula($nome_estabelecimento) . '%0A';
$mensagem_whatsapp .= '📍 Bairro ID: ' . encode_com_underscore_preservando_virgula($bairro_id) . '%0A';  // Exibindo o bairro_id
$mensagem_whatsapp .= '💰 Taxa: R$ ' . encode_com_underscore_preservando_virgula(number_format($taxa, 2, ',', '.')) . '%0A';
$mensagem_whatsapp .= '💵 Valor Líquido: R$ ' . encode_com_underscore_preservando_virgula(number_format($valor_liquido, 2, ',', '.')) . '%0A';
$mensagem_whatsapp .= '⏰ *Disponível às: ' . $horario_formatado . '*%0A';

require '.../apis/texto.php';

echo "Entrega cadastrada e mensagem enviada com sucesso!";
?>
